/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.NewIsland;
import world.bentobox.bentobox.panels.customizable.IslandCreationPanel;
import world.bentobox.bentobox.util.Util;

public class IslandResetCommand
extends ConfirmableCommand {
    private boolean noPaste;

    public IslandResetCommand(CompositeCommand islandCommand) {
        super(islandCommand, "reset", "restart");
    }

    public IslandResetCommand(CompositeCommand islandCommand, boolean noPaste) {
        super(islandCommand, "reset", "restart");
        this.noPaste = noPaste;
    }

    @Override
    public void setup() {
        this.setPermission("island.reset");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.reset.parameters");
        this.setDescription("commands.island.reset.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (this.getSettings().getResetCooldown() > 0 && this.checkCooldown(user)) {
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        int resetsLeft = this.getPlayers().getResetsLeft(this.getWorld(), user.getUniqueId());
        if (resetsLeft != -1) {
            if (resetsLeft == 0) {
                user.sendMessage("commands.island.reset.none-left", new String[0]);
                return false;
            }
            user.sendMessage("commands.island.reset.resets-left", "[number]", String.valueOf(resetsLeft));
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            String name = this.getPlugin().getBlueprintsManager().validate((GameModeAddon)this.getAddon(), Util.sanitizeInput(args.get(0)));
            if (name == null || name.isEmpty()) {
                user.sendMessage("commands.island.create.unknown-blueprint", new String[0]);
                return false;
            }
            if (!this.getPlugin().getBlueprintsManager().checkPerm((Addon)this.getAddon(), user, Util.sanitizeInput(args.get(0)))) {
                return false;
            }
            return this.resetIsland(user, name);
        }
        if (this.getPlugin().getSettings().isResetConfirmation()) {
            this.askConfirmation(user, user.getTranslation("commands.island.reset.confirmation", new String[0]), () -> this.selectBundle(user, label));
        } else {
            this.selectBundle(user, label);
        }
        return true;
    }

    private void selectBundle(@NonNull User user, @NonNull String label) {
        if (this.getPlugin().getBlueprintsManager().getBlueprintBundles((GameModeAddon)this.getAddon()).size() > 1) {
            IslandCreationPanel.openPanel(this, user, label, true);
        } else {
            this.resetIsland(user, "default");
        }
    }

    private boolean resetIsland(User user, String name) {
        Island oldIsland = this.getIslands().getIsland(this.getWorld(), user);
        this.deleteOldIsland(user, oldIsland);
        user.sendMessage("commands.island.create.creating-island", new String[0]);
        try {
            NewIsland.Builder builder = NewIsland.builder().player(user).reason(IslandEvent.Reason.RESET).addon((GameModeAddon)this.getAddon()).oldIsland(oldIsland).name(name);
            if (this.noPaste) {
                builder.noPaste();
            }
            builder.build();
        }
        catch (IOException e) {
            this.getPlugin().logError("Could not create island for player. " + e.getMessage());
            user.sendMessage(e.getMessage(), new String[0]);
            return false;
        }
        this.setCooldown(user.getUniqueId(), this.getSettings().getResetCooldown());
        return true;
    }

    private void deleteOldIsland(User user, Island oldIsland) {
        IslandEvent.builder().involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.PRECLEAR).island(oldIsland).oldIsland(oldIsland).location(oldIsland.getCenter()).build();
        this.kickMembers(oldIsland);
        this.getPlayers().addReset(this.getWorld(), user.getUniqueId());
    }

    private void kickMembers(Island island) {
        island.getMemberSet().forEach(memberUUID -> {
            User member = User.getInstance(memberUUID);
            if (!memberUUID.equals(island.getOwner())) {
                member.sendMessage("commands.island.reset.kicked-from-island", "[gamemode]", ((Addon)this.getAddon()).getDescription().getName());
            }
            this.getIslands().removePlayer(island, (UUID)memberUUID);
            this.getPlayers().cleanLeavingPlayer(this.getWorld(), member, false, island);
            TeamEvent.builder().island(island).reason(TeamEvent.Reason.DELETE).involvedPlayer((UUID)memberUUID).build();
        });
    }
}

