/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandSetnameCommand
extends CompositeCommand {
    public IslandSetnameCommand(CompositeCommand islandCommand) {
        super(islandCommand, "setname", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.name");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.setname.parameters");
        this.setDescription("commands.island.setname.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        String name = String.join((CharSequence)" ", args);
        if (name.length() < this.getSettings().getNameMinLength() || Util.stripColor(name).isEmpty()) {
            user.sendMessage("commands.island.setname.name-too-short", "[number]", String.valueOf(this.getSettings().getNameMinLength()));
            return false;
        }
        if (name.length() > this.getSettings().getNameMaxLength()) {
            user.sendMessage("commands.island.setname.name-too-long", "[number]", String.valueOf(this.getSettings().getNameMaxLength()));
            return false;
        }
        if (user.hasPermission(this.getPermissionPrefix() + "island.name.format")) {
            name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        String name = String.join((CharSequence)" ", args);
        if (user.hasPermission(this.getPermissionPrefix() + "island.name.format")) {
            name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        }
        Island island = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), user));
        String previousName = island.getName();
        island.setName(name);
        user.sendMessage("commands.island.setname.success", "[name]", name);
        new IslandEvent.IslandEventBuilder().island(island).involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.NAME).previousName(previousName).admin(false).build();
        return true;
    }
}

