/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamInviteGUI;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.panels.reader.PanelTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.TeamInvite;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamGUI {
    private static final List<Integer> RANKS = List.of(Integer.valueOf(1000), Integer.valueOf(900), Integer.valueOf(500), Integer.valueOf(400), Integer.valueOf(200));
    private static final String NAME = ".name";
    private static final String TIPS = "commands.island.team.gui.tips.";
    private final User user;
    private final Island island;
    private int rankView = 1000;
    private @Nullable PanelTemplateRecord.TemplateItem border;
    private @Nullable PanelTemplateRecord.TemplateItem background;
    private final IslandTeamCommand parent;
    private final BentoBox plugin;

    public IslandTeamGUI(BentoBox plugin, IslandTeamCommand parent, User user, Island island) {
        this.parent = parent;
        this.plugin = plugin;
        this.user = user;
        this.island = island;
        if (!new File(String.valueOf(plugin.getDataFolder()) + File.separator + "panels", "team_panel.yml").exists()) {
            plugin.saveResource("panels/team_panel.yml", false);
        }
    }

    public void build() {
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        panelBuilder.user(this.user);
        panelBuilder.world(this.user.getWorld());
        panelBuilder.template("team_panel", new File(this.plugin.getDataFolder(), "panels"));
        panelBuilder.parameters("[name]", this.user.getName(), "[display_name]", this.user.getDisplayName());
        panelBuilder.registerTypeBuilder("STATUS", this::createStatusButton);
        panelBuilder.registerTypeBuilder("MEMBER", this::createMemberButton);
        panelBuilder.registerTypeBuilder("INVITED", this::createInvitedButton);
        panelBuilder.registerTypeBuilder("RANK", this::createRankButton);
        panelBuilder.registerTypeBuilder("INVITE", this::createInviteButton);
        this.border = panelBuilder.getPanelTemplate().border();
        this.background = panelBuilder.getPanelTemplate().background();
        panelBuilder.build();
    }

    private PanelItem createInviteButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.island == null || !this.user.hasPermission(this.parent.getInviteCommand().getPermission()) || this.island.getRank(this.user) < this.island.getRankCommand(this.parent.getLabel() + " invite")) {
            return this.getBlankBorder();
        }
        PanelItemBuilder builder = new PanelItemBuilder();
        builder.icon(Material.PLAYER_HEAD);
        builder.name(this.user.getTranslation("commands.island.team.gui.buttons.invite.name", new String[0]));
        builder.description(this.user.getTranslation("commands.island.team.gui.buttons.invite.description", new String[0]));
        builder.clickHandler((panel, user, clickType, clickSlot) -> {
            if (template.actions().stream().noneMatch(ar -> clickType.equals((Object)ar.clickType()))) {
                return true;
            }
            if (clickType.equals((Object)ClickType.LEFT)) {
                user.closeInventory();
                new IslandTeamInviteGUI(this.parent, false, this.island).build(user);
            }
            return true;
        });
        return builder.build();
    }

    private PanelItem createRankButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.island == null) {
            return this.getBlankBorder();
        }
        PanelItemBuilder builder = new PanelItemBuilder();
        builder.name(this.user.getTranslation("commands.island.team.gui.buttons.rank-filter.name", new String[0]));
        builder.icon(Material.AMETHYST_SHARD);
        this.createDescription(builder);
        this.createClickHandler(builder, template.actions());
        return builder.build();
    }

    private void createClickHandler(PanelItemBuilder builder, @NonNull List<ItemTemplateRecord.ActionRecords> actions) {
        builder.clickHandler((panel, user, clickType, clickSlot) -> {
            if (actions.stream().noneMatch(ar -> clickType.equals((Object)ar.clickType()))) {
                return true;
            }
            if (clickType.equals((Object)ClickType.LEFT)) {
                this.rankView = RanksManager.getInstance().getRankDownValue(this.rankView);
                if (this.rankView <= 0) {
                    this.rankView = 1000;
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
                } else {
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                }
            }
            if (clickType.equals((Object)ClickType.RIGHT)) {
                this.rankView = RanksManager.getInstance().getRankUpValue(this.rankView);
                if (this.rankView >= 1000) {
                    this.rankView = RanksManager.getInstance().getRankUpValue(0);
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
                } else {
                    user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                }
            }
            this.build();
            return true;
        });
    }

    private void createDescription(PanelItemBuilder builder) {
        RanksManager.getInstance().getRanks().forEach((reference, score) -> {
            if (this.rankView == 1000 && score > 0 && score <= 1000) {
                builder.description(this.user.getTranslation("protection.panel.flag-item.allowed-rank", new String[0]) + this.user.getTranslation((String)reference, new String[0]));
            } else if (score > 0 && score < this.rankView) {
                builder.description(this.user.getTranslation("protection.panel.flag-item.blocked-rank", new String[0]) + this.user.getTranslation((String)reference, new String[0]));
            } else if (score <= 1000 && score > this.rankView) {
                builder.description(this.user.getTranslation("protection.panel.flag-item.blocked-rank", new String[0]) + this.user.getTranslation((String)reference, new String[0]));
            } else if (score == this.rankView) {
                builder.description(this.user.getTranslation("protection.panel.flag-item.allowed-rank", new String[0]) + this.user.getTranslation((String)reference, new String[0]));
            }
        });
        builder.description(this.user.getTranslation("commands.island.team.gui.buttons.rank-filter.description", new String[0]));
    }

    private PanelItem createInvitedButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        TeamInvite invite;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (this.parent.isInvited(this.user.getUniqueId()) && this.user.hasPermission(this.parent.getAcceptCommand().getPermission())) {
            invite = this.parent.getInvite(this.user.getUniqueId());
            if (invite == null) {
                return this.getBlankBorder();
            }
        } else {
            return this.getBlankBorder();
        }
        User inviter = User.getInstance(invite.getInviter());
        String name = inviter.getName();
        builder.icon(inviter.getName());
        builder.name(this.user.getTranslation("commands.island.team.gui.buttons.invitation", new String[0]));
        this.createInviteDescription(builder, invite.getType(), name, template.actions());
        this.createInviteClickHandler(builder, invite, template.actions());
        return builder.build();
    }

    private void createInviteClickHandler(PanelItemBuilder builder, TeamInvite invite, @NonNull List<ItemTemplateRecord.ActionRecords> list) {
        TeamInvite.Type type = invite.getType();
        builder.clickHandler((panel, user, clickType, clickSlot) -> {
            if (list.stream().noneMatch(ar -> clickType.equals((Object)ar.clickType()))) {
                return true;
            }
            if (clickType.equals((Object)ClickType.SHIFT_LEFT) && user.hasPermission(this.parent.getAcceptCommand().getPermission())) {
                this.plugin.log("Invite accepted: " + user.getName() + " accepted " + String.valueOf((Object)type));
                switch (type) {
                    case COOP: {
                        this.parent.getAcceptCommand().acceptCoopInvite(user, invite);
                        break;
                    }
                    case TRUST: {
                        this.parent.getAcceptCommand().acceptTrustInvite(user, invite);
                        break;
                    }
                    default: {
                        this.parent.getAcceptCommand().acceptTeamInvite(user, invite);
                    }
                }
                user.closeInventory();
            }
            if (clickType.equals((Object)ClickType.SHIFT_RIGHT) && user.hasPermission(this.parent.getRejectCommand().getPermission())) {
                this.plugin.log("Invite rejected: " + user.getName() + " rejected " + String.valueOf((Object)type) + " invite.");
                this.parent.getRejectCommand().execute(user, "", List.of());
                user.closeInventory();
            }
            return true;
        });
    }

    private void createInviteDescription(PanelItemBuilder builder, TeamInvite.Type type, String name, @NonNull List<ItemTemplateRecord.ActionRecords> list) {
        builder.description(switch (type) {
            case TeamInvite.Type.COOP -> List.of(this.user.getTranslation("commands.island.team.invite.name-has-invited-you.coop", "[name]", name));
            case TeamInvite.Type.TRUST -> List.of(this.user.getTranslation("commands.island.team.invite.name-has-invited-you.trust", "[name]", name));
            default -> List.of(this.user.getTranslation("commands.island.team.invite.name-has-invited-you", "[name]", name), this.user.getTranslation("commands.island.team.invite.accept.confirmation", new String[0]));
        });
        builder.description(list.stream().map(ar -> this.user.getTranslation(TIPS + ar.clickType().name() + NAME, new String[0]) + " " + this.user.getTranslation(ar.tooltip(), new String[0])).toList());
    }

    private PanelItem createStatusButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        PanelItemBuilder builder = new PanelItemBuilder();
        Island is = this.plugin.getIslands().getPrimaryIsland(this.parent.getWorld(), this.user.getUniqueId());
        if (is == null) {
            return this.getBlankBorder();
        }
        return builder.icon(this.user.getName()).name(this.user.getTranslation("commands.island.team.gui.buttons.status.name", new String[0])).description(this.showMembers()).build();
    }

    private PanelItem getBlankBorder() {
        return new PanelItemBuilder().icon(Objects.requireNonNullElse(this.border.icon(), new ItemStack(Material.BARRIER))).name(Objects.requireNonNullElse(this.border.title(), "")).build();
    }

    private PanelItem getBlankBackground() {
        return new PanelItemBuilder().icon(Objects.requireNonNullElse(this.background.icon(), new ItemStack(Material.BARRIER))).name(Objects.requireNonNullElse(this.background.title(), "")).build();
    }

    private PanelItem createMemberButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        Island is = this.plugin.getIslands().getPrimaryIsland(this.parent.getWorld(), this.user.getUniqueId());
        if (is == null) {
            return this.getBlankBackground();
        }
        int minimumRank = RanksManager.getInstance().getRankUpValue(0);
        Optional<User> opMember = is.getMemberSet(minimumRank).stream().map(User::getInstance).filter(usr -> this.rankView == 1000 || is.getRank((User)usr) == this.rankView).sorted(Comparator.comparingInt(usr -> is.getRank((User)usr)).reversed()).skip(slot.slot()).limit(1L).findFirst();
        if (opMember.isEmpty()) {
            return this.getBlankBackground();
        }
        User member = opMember.get();
        int rank = is.getRank(member);
        String rankRef = RanksManager.getInstance().getRank(rank);
        @NonNull List<ItemTemplateRecord.ActionRecords> actions = template.actions();
        ArrayList<String> desc = new ArrayList<String>();
        int userRank = Objects.requireNonNull(is).getRank(this.user);
        if (this.user.hasPermission(this.parent.getKickCommand().getPermission()) && userRank >= is.getRankCommand(this.parent.getLabel() + " kick") && !this.user.equals(member)) {
            actions.stream().filter(ar -> ar.actionType().equalsIgnoreCase("kick")).map(ar -> this.user.getTranslation(TIPS + ar.clickType().name() + NAME, new String[0]) + " " + this.user.getTranslation(ar.tooltip(), new String[0])).findFirst().ifPresent(desc::add);
        }
        if (this.user.hasPermission(this.parent.getSetOwnerCommand().getPermission()) && !this.user.equals(member) && userRank >= 1000 && rank >= 500) {
            actions.stream().filter(ar -> ar.actionType().equalsIgnoreCase("setowner")).map(ar -> this.user.getTranslation(TIPS + ar.clickType().name() + NAME, new String[0]) + " " + this.user.getTranslation(ar.tooltip(), new String[0])).findFirst().ifPresent(desc::add);
        }
        if (this.user.hasPermission(this.parent.getLeaveCommand().getPermission()) && this.user.equals(member) && userRank < 1000) {
            actions.stream().filter(ar -> ar.actionType().equalsIgnoreCase("leave")).map(ar -> this.user.getTranslation(TIPS + ar.clickType().name() + NAME, new String[0]) + " " + this.user.getTranslation(ar.tooltip(), new String[0])).findFirst().ifPresent(desc::add);
        }
        if (member.isOnline()) {
            desc.add(0, this.user.getTranslation(rankRef, new String[0]));
            return new PanelItemBuilder().icon(member.getName()).name(member.getDisplayName()).description(desc).clickHandler((panel, user, clickType, i) -> this.clickListener(panel, user, clickType, i, member, actions)).build();
        }
        desc.add(0, this.user.getTranslation(rankRef, new String[0]));
        return new PanelItemBuilder().icon(member.getName()).name(this.offlinePlayerStatus(Bukkit.getOfflinePlayer((UUID)member.getUniqueId()))).description(desc).clickHandler((panel, user, clickType, i) -> this.clickListener(panel, user, clickType, i, member, actions)).build();
    }

    private boolean clickListener(Panel panel, User clickingUser, ClickType clickType, int i, User target, List<ItemTemplateRecord.ActionRecords> actions) {
        if (actions.stream().noneMatch(ar -> clickType.equals((Object)ar.clickType()))) {
            return true;
        }
        int rank = Objects.requireNonNull(this.island).getRank(clickingUser);
        for (ItemTemplateRecord.ActionRecords action : actions) {
            if (!clickType.equals((Object)action.clickType())) continue;
            switch (action.actionType().toUpperCase(Locale.ENGLISH)) {
                case "KICK": {
                    this.kickPlayer(clickingUser, target, rank);
                    break;
                }
                case "SETOWNER": {
                    this.setOwner(clickingUser, target);
                    break;
                }
                case "LEAVE": {
                    this.leave(clickingUser, target);
                    break;
                }
            }
        }
        return true;
    }

    private void leave(User clickingUser, User target) {
        if (clickingUser.hasPermission(this.parent.getLeaveCommand().getPermission()) && target.equals(clickingUser) && !clickingUser.getUniqueId().equals(this.island.getOwner())) {
            this.plugin.log("Leave: " + clickingUser.getName() + " trying to leave island at " + String.valueOf(this.island.getCenter()));
            clickingUser.closeInventory();
            if (this.parent.getLeaveCommand().leave(clickingUser)) {
                this.plugin.log("Leave: success");
            } else {
                this.plugin.log("Leave: failed");
            }
        }
    }

    private void setOwner(User clickingUser, User target) {
        if (clickingUser.hasPermission(this.parent.getSetOwnerCommand().getPermission()) && !target.equals(clickingUser) && clickingUser.getUniqueId().equals(this.island.getOwner()) && this.island.getRank(target) >= 500) {
            this.plugin.log("Set Owner: " + clickingUser.getName() + " trying to make " + target.getName() + " owner of island at " + String.valueOf(this.island.getCenter()));
            clickingUser.closeInventory();
            if (this.parent.getSetOwnerCommand().setOwner(clickingUser, target.getUniqueId())) {
                this.plugin.log("Set Owner: success");
            } else {
                this.plugin.log("Set Owner: failed");
            }
        }
    }

    private void kickPlayer(User clickingUser, User target, int rank) {
        if (clickingUser.hasPermission(this.parent.getKickCommand().getPermission()) && !target.equals(clickingUser) && rank >= this.island.getRankCommand(this.parent.getLabel() + " kick")) {
            this.plugin.log("Kick: " + clickingUser.getName() + " kicked " + target.getName() + " from island at " + String.valueOf(this.island.getCenter()));
            clickingUser.closeInventory();
            if (this.removePlayer(clickingUser, target)) {
                clickingUser.getPlayer().playSound(clickingUser.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                this.plugin.log("Kick: success");
            } else {
                this.plugin.log("Kick: failed");
            }
        }
    }

    private boolean removePlayer(User clicker, User member) {
        return switch (this.island.getRank(member)) {
            case 200 -> this.parent.getUncoopCommand().unCoopCmd(this.user, member.getUniqueId());
            case 400 -> this.parent.getUnTrustCommand().unTrustCmd(this.user, member.getUniqueId());
            default -> this.parent.getKickCommand().canExecute(this.user, this.parent.getKickCommand().getLabel(), List.of(member.getName())) ? this.parent.getKickCommand().kick(clicker, member.getUniqueId()) : false;
        };
    }

    private List<String> showMembers() {
        ArrayList<String> message = new ArrayList<String>();
        long onlineMemberCount = this.island.getMemberSet(500).stream().filter(uuid -> Util.getOnlinePlayerList(this.user).contains(Bukkit.getOfflinePlayer((UUID)uuid).getName())).count();
        message.add(this.user.getTranslation("commands.island.team.info.header", "[max]", String.valueOf(this.plugin.getIslands().getMaxMembers(this.island, 500)), "[total]", String.valueOf(this.island.getMemberSet().size()), "[online]", String.valueOf(onlineMemberCount)));
        List<UUID> onlineMembers = this.island.getMemberSet(200).stream().filter(uuid -> Util.getOnlinePlayerList(this.user).contains(Bukkit.getOfflinePlayer((UUID)uuid).getName())).toList();
        for (int rank : RANKS) {
            ImmutableSet<UUID> players = this.island.getMemberSet(rank, false);
            if (players.isEmpty()) continue;
            if (rank == 1000) {
                message.add(this.user.getTranslation("commands.island.team.info.rank-layout.owner", "[rank]", this.user.getTranslation("ranks.owner", new String[0])));
            } else {
                message.add(this.user.getTranslation("commands.island.team.info.rank-layout.generic", "[rank]", this.user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]), "[number]", String.valueOf(this.island.getMemberSet(rank, false).size())));
            }
            message.addAll(this.displayOnOffline(rank, this.island, onlineMembers));
        }
        return message;
    }

    private List<String> displayOnOffline(int rank, Island island, List<UUID> onlineMembers) {
        ArrayList<String> message = new ArrayList<String>();
        for (UUID member : island.getMemberSet(rank, false)) {
            message.add(this.getMemberStatus(member, onlineMembers.contains(member)));
        }
        return message;
    }

    private String getMemberStatus(UUID member, boolean online) {
        OfflinePlayer offlineMember = Bukkit.getOfflinePlayer((UUID)member);
        if (online) {
            return this.user.getTranslation("commands.island.team.info.member-layout.online", "[name]", offlineMember.getName());
        }
        return this.offlinePlayerStatus(offlineMember);
    }

    private String offlinePlayerStatus(OfflinePlayer offlineMember) {
        String lastSeen = this.lastSeen(offlineMember);
        if (this.island.getMemberSet(500, true).contains((Object)offlineMember.getUniqueId())) {
            return this.user.getTranslation("commands.island.team.info.member-layout.offline", "[name]", offlineMember.getName(), "[last_seen]", lastSeen);
        }
        return this.user.getTranslation("commands.island.team.info.member-layout.offline-not-last-seen", "[name]", offlineMember.getName());
    }

    private String lastSeen(OfflinePlayer offlineMember) {
        Instant lastJoined = Instant.ofEpochMilli(offlineMember.getLastSeen());
        Instant now = Instant.now();
        Duration duration = Duration.between(lastJoined, now);
        String reference = "commands.island.team.info.last-seen.layout";
        String lastSeen = duration.toMinutes() < 60L ? this.user.getTranslation("commands.island.team.info.last-seen.layout", "[number]", String.valueOf(duration.toMinutes()), "[unit]", this.user.getTranslation("commands.island.team.info.last-seen.minutes", new String[0])) : (duration.toHours() < 24L ? this.user.getTranslation("commands.island.team.info.last-seen.layout", "[number]", String.valueOf(duration.toHours()), "[unit]", this.user.getTranslation("commands.island.team.info.last-seen.hours", new String[0])) : this.user.getTranslation("commands.island.team.info.last-seen.layout", "[number]", String.valueOf(duration.toDays()), "[unit]", this.user.getTranslation("commands.island.team.info.last-seen.days", new String[0])));
        return lastSeen;
    }
}

