/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.TeamInvite;
import world.bentobox.bentobox.util.Util;

public class IslandTeamInviteAcceptCommand
extends ConfirmableCommand {
    private static final String INVALID_INVITE = "commands.island.team.invite.errors.invalid-invite";
    private final IslandTeamCommand itc;

    public IslandTeamInviteAcceptCommand(IslandTeamCommand islandTeamCommand) {
        super(islandTeamCommand, "accept", new String[0]);
        this.itc = islandTeamCommand;
    }

    @Override
    public void setup() {
        this.setPermission("island.team.accept");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.team.invite.accept.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        UUID playerUUID = user.getUniqueId();
        if (!this.itc.isInvited(playerUUID)) {
            user.sendMessage("commands.island.team.invite.errors.none-invited-you", new String[0]);
            return false;
        }
        UUID prospectiveOwnerUUID = this.itc.getInviter(playerUUID);
        if (prospectiveOwnerUUID == null) {
            user.sendMessage(INVALID_INVITE, new String[0]);
            this.itc.removeInvite(playerUUID);
            return false;
        }
        TeamInvite invite = this.itc.getInvite(playerUUID);
        if (invite.getType().equals((Object)TeamInvite.Type.TEAM)) {
            Island island = this.getIslands().getIsland(this.getWorld(), prospectiveOwnerUUID);
            String inviteUsage = this.getParent().getSubCommand("invite").map(CompositeCommand::getUsage).orElse("");
            if (island == null || island.getRank(prospectiveOwnerUUID) < island.getRankCommand(inviteUsage)) {
                user.sendMessage(INVALID_INVITE, new String[0]);
                this.itc.removeInvite(playerUUID);
                return false;
            }
            if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIslands().inTeam(this.getWorld(), playerUUID)) {
                user.sendMessage("commands.island.team.invite.errors.you-already-are-in-team", new String[0]);
                this.itc.removeInvite(playerUUID);
                return false;
            }
            IslandBaseEvent e = TeamEvent.builder().island(this.getIslands().getIsland(this.getWorld(), prospectiveOwnerUUID)).reason(TeamEvent.Reason.JOIN).involvedPlayer(playerUUID).build();
            return e.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(e.isCancelled()) == false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        TeamInvite invite = this.itc.getInvite(user.getUniqueId());
        switch (invite.getType()) {
            case COOP: {
                this.askConfirmation(user, () -> this.acceptCoopInvite(user, invite));
                break;
            }
            case TRUST: {
                this.askConfirmation(user, () -> this.acceptTrustInvite(user, invite));
                break;
            }
            default: {
                if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands()) {
                    this.askConfirmation(user, user.getTranslation("commands.island.team.invite.accept.confirmation", new String[0]), () -> this.acceptTeamInvite(user, invite));
                    break;
                }
                this.acceptTeamInvite(user, invite);
            }
        }
        return true;
    }

    void acceptTrustInvite(User user, TeamInvite invite) {
        this.itc.removeInvite(user.getUniqueId());
        User inviter = User.getInstance(invite.getInviter());
        Island island = this.getIslands().getIslandById(invite.getIslandID()).orElse(null);
        if (island != null) {
            if (island.getMemberSet(400, false).size() > this.getIslands().getMaxMembers(island, 400)) {
                user.sendMessage("commands.island.team.trust.is-full", new String[0]);
                return;
            }
            island.setRank(user, 400);
            IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(island.getRank(user), 400).build();
            if (inviter.isOnline()) {
                inviter.sendMessage("commands.island.team.trust.success", "[name]", user.getName(), "[display_name]", user.getDisplayName());
            }
            if (inviter.isPlayer()) {
                user.sendMessage("commands.island.team.trust.you-are-trusted", "[name]", inviter.getName(), "[display_name]", inviter.getDisplayName());
            }
            island.log(new LogEntry.Builder(LogEntry.LogType.TRUSTED).data(user.getUniqueId().toString(), "trusted").data(invite.getInviter().toString(), "trusted by").build());
        }
    }

    void acceptCoopInvite(User user, TeamInvite invite) {
        this.itc.removeInvite(user.getUniqueId());
        User inviter = User.getInstance(invite.getInviter());
        Island island = this.getIslands().getIslandById(invite.getIslandID()).orElse(null);
        if (island != null) {
            if (island.getMemberSet(200, false).size() > this.getIslands().getMaxMembers(island, 200)) {
                user.sendMessage("commands.island.team.coop.is-full", new String[0]);
                return;
            }
            island.setRank(user, 200);
            IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(island.getRank(user), 200).build();
            if (inviter.isOnline()) {
                inviter.sendMessage("commands.island.team.coop.success", "[name]", user.getName(), "[display_name]", user.getDisplayName());
            }
            if (inviter.isPlayer()) {
                user.sendMessage("commands.island.team.coop.you-are-a-coop-member", "[name]", inviter.getName(), "[display_name]", inviter.getDisplayName());
            }
        }
    }

    void acceptTeamInvite(User user, TeamInvite invite) {
        this.itc.removeInvite(user.getUniqueId());
        List<Island> islands = this.getIslands().getIslands(this.getWorld(), user.getUniqueId());
        Island teamIsland = this.getIslands().getIslandById(invite.getIslandID()).orElse(null);
        if (teamIsland == null) {
            user.sendMessage(INVALID_INVITE, new String[0]);
            return;
        }
        if (teamIsland.getMemberSet(500, true).size() >= this.getIslands().getMaxMembers(teamIsland, 500)) {
            user.sendMessage("commands.island.team.invite.errors.island-is-full", new String[0]);
            return;
        }
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands()) {
            this.getIslands().removePlayer(this.getWorld(), user.getUniqueId());
            this.cleanPlayer(user);
        }
        this.getIslands().setJoinTeam(teamIsland, user.getUniqueId());
        this.getIslands().setPrimaryIsland(user.getUniqueId(), teamIsland);
        this.getIslands().homeTeleportAsync(this.getWorld(), user.getPlayer()).thenRun(() -> {
            if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands()) {
                islands.forEach(island -> this.getIslands().deleteIsland((Island)island, true, user.getUniqueId()));
            }
            user.setGameMode(this.getIWM().getDefaultGameMode(this.getWorld()));
            String ownerName = this.getPlayers().getName(teamIsland.getOwner());
            Util.runCommands(user, ownerName, this.getIWM().getOnJoinCommands(this.getWorld()), "join");
        });
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIWM().isTeamJoinDeathReset(this.getWorld())) {
            this.getPlayers().setDeaths(this.getWorld(), user.getUniqueId(), 0);
        }
        user.sendMessage("commands.island.team.invite.accept.you-joined-island", "[label]", this.getTopLabel());
        User inviter = User.getInstance(invite.getInviter());
        if (inviter.isOnline()) {
            inviter.sendMessage("commands.island.team.invite.accept.name-joined-your-island", "[name]", user.getName(), "[display_name]", user.getDisplayName());
        }
        TeamEvent.builder().island(teamIsland).reason(TeamEvent.Reason.JOINED).involvedPlayer(user.getUniqueId()).build();
        IslandEvent.builder().island(teamIsland).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(teamIsland.getRank(user), 500).build();
    }

    private void cleanPlayer(User user) {
        if (this.getIWM().isOnLeaveResetEnderChest(this.getWorld()) || this.getIWM().isOnJoinResetEnderChest(this.getWorld())) {
            user.getPlayer().getEnderChest().clear();
        }
        if (this.getIWM().isOnLeaveResetInventory(this.getWorld()) || this.getIWM().isOnJoinResetInventory(this.getWorld())) {
            user.getPlayer().getInventory().clear();
        }
        if (this.getSettings().isUseEconomy() && (this.getIWM().isOnLeaveResetMoney(this.getWorld()) || this.getIWM().isOnJoinResetMoney(this.getWorld()))) {
            this.getPlugin().getVault().ifPresent(vault -> vault.withdraw(user, vault.getBalance(user)));
        }
        if (this.getIWM().isOnJoinResetHealth(this.getWorld())) {
            Util.resetHealth(user.getPlayer());
        }
        if (this.getIWM().isOnJoinResetHunger(this.getWorld())) {
            user.getPlayer().setFoodLevel(20);
        }
        if (this.getIWM().isOnJoinResetXP(this.getWorld())) {
            user.getPlayer().setLevel(0);
            user.getPlayer().setExp(0.0f);
            user.getPlayer().setTotalExperience(0);
        }
    }
}

