/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;

public class IslandTeamInviteRejectCommand
extends CompositeCommand {
    private final IslandTeamCommand itc;

    public IslandTeamInviteRejectCommand(IslandTeamCommand islandTeamCommand) {
        super(islandTeamCommand, "reject", new String[0]);
        this.itc = islandTeamCommand;
    }

    @Override
    public void setup() {
        this.setPermission("island.team.reject");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.team.invite.reject.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        UUID playerUUID = user.getUniqueId();
        if (this.itc.isInvited(playerUUID)) {
            IslandBaseEvent e = TeamEvent.builder().island(this.getIslands().getIsland(this.getWorld(), user.getUniqueId())).reason(TeamEvent.Reason.REJECT).involvedPlayer(playerUUID).build();
            if (e.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(e.isCancelled()).booleanValue()) {
                return false;
            }
        } else {
            user.sendMessage("commands.island.team.invite.errors.none-invited-you", new String[0]);
            return false;
        }
        Optional.ofNullable(this.itc.getInviter(playerUUID)).map(User::getInstance).ifPresent(inviter -> inviter.sendMessage("commands.island.team.invite.reject.name-rejected-your-invite", "[name]", user.getName(), "[display_name]", user.getDisplayName()));
        this.itc.removeInvite(user.getUniqueId());
        user.sendMessage("commands.island.team.invite.reject.you-rejected-invite", new String[0]);
        return true;
    }
}

