/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamKickCommand
extends ConfirmableCommand {
    public IslandTeamKickCommand(CompositeCommand islandTeamCommand) {
        super(islandTeamCommand, "kick", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.team.kick");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.team.kick.parameters");
        this.setDescription("commands.island.team.kick.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-team", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (targetUUID.equals(user.getUniqueId())) {
            user.sendMessage("commands.island.team.kick.cannot-kick", new String[0]);
            return false;
        }
        if (!this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()).inTeam(targetUUID)) {
            user.sendMessage("general.errors.not-in-team", new String[0]);
            return false;
        }
        int targetRank = Objects.requireNonNull(island).getRank(targetUUID);
        if (rank <= targetRank) {
            user.sendMessage("commands.island.team.kick.cannot-kick-rank", "[name]", this.getPlayers().getName(targetUUID));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (!this.getSettings().isKickConfirmation()) {
            this.kick(user, targetUUID);
            return true;
        }
        this.askConfirmation(user, () -> this.kick(user, targetUUID));
        return false;
    }

    protected boolean kick(User user, UUID targetUUID) {
        if (targetUUID == null) {
            return false;
        }
        User target = User.getInstance(targetUUID);
        Island oldIsland = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), user));
        IslandBaseEvent event = TeamEvent.builder().island(oldIsland).reason(TeamEvent.Reason.KICK).involvedPlayer(targetUUID).build();
        if (event.isCancelled()) {
            return false;
        }
        target.sendMessage("commands.island.team.kick.player-kicked", "[gamemode]", ((Addon)this.getAddon()).getDescription().getName(), "[name]", user.getName(), "[display_name]", user.getDisplayName());
        this.getIslands().removePlayer(oldIsland, targetUUID);
        this.getPlayers().cleanLeavingPlayer(this.getWorld(), target, true, oldIsland);
        user.sendMessage("commands.island.team.kick.success", "[name]", target.getName(), "[display_name]", target.getDisplayName());
        IslandEvent.builder().island(oldIsland).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(oldIsland.getRank(user), 0).build();
        if (this.getSettings().getInviteCooldown() > 0 && this.getParent() != null) {
            this.getParent().getSubCommand("invite").ifPresent(c -> c.setCooldown(oldIsland.getUniqueId(), targetUUID.toString(), this.getSettings().getInviteCooldown() * 60));
        }
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            List<String> options = island.getMemberSet().stream().filter(uuid -> island.getRank((UUID)uuid) >= 500).map(Bukkit::getOfflinePlayer).map(OfflinePlayer::getName).toList();
            String lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

