/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.events.team.TeamEvent;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class IslandTeamSetownerCommand
extends CompositeCommand {
    private @Nullable UUID targetUUID;

    public IslandTeamSetownerCommand(CompositeCommand islandTeamCommand) {
        super(islandTeamCommand, "setowner", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.team.setowner");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.team.setowner.parameters");
        this.setDescription("commands.island.team.setowner.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        Island is = this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId());
        if (is == null || !is.inTeam(user.getUniqueId())) {
            user.sendMessage("general.errors.no-team", new String[0]);
            return false;
        }
        UUID ownerUUID = is.getOwner();
        if (ownerUUID == null || !ownerUUID.equals(user.getUniqueId())) {
            user.sendMessage("general.errors.not-owner", new String[0]);
            return false;
        }
        this.targetUUID = this.getPlayers().getUUID(args.get(0));
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (this.targetUUID.equals(user.getUniqueId())) {
            user.sendMessage("commands.island.team.setowner.errors.cant-transfer-to-yourself", new String[0]);
            return false;
        }
        if (!is.inTeam(this.targetUUID)) {
            user.sendMessage("commands.island.team.setowner.errors.target-is-not-member", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        return this.setOwner(user, this.targetUUID);
    }

    protected boolean setOwner(User user, @NonNull UUID targetUUID2) {
        Island island = this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId());
        IslandBaseEvent e = TeamEvent.builder().island(island).reason(TeamEvent.Reason.SETOWNER).involvedPlayer(targetUUID2).build();
        if (e.isCancelled()) {
            return false;
        }
        this.getIslands().setOwner(this.getWorld(), user, targetUUID2);
        IslandEvent.builder().island(island).involvedPlayer(targetUUID2).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(island.getRank(User.getInstance(targetUUID2)), 1000).build();
        IslandEvent.builder().island(island).involvedPlayer(user.getUniqueId()).admin(false).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(1000, 900).build();
        island.log(new LogEntry.Builder(LogEntry.LogType.NEWOWNER).data(targetUUID2.toString(), "new owner").data(user.getUniqueId().toString(), "old owner").build());
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()) == null) {
            return Optional.empty();
        }
        return Optional.of(Util.tabLimit(this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()).getMemberSet().stream().filter(uuid -> !user.getUniqueId().equals(uuid)).map(this.getPlayers()::getName).toList(), lastArg));
    }
}

