/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.configuration;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.yaml.YamlDatabase;

public class Config<T> {
    private final AbstractDatabaseHandler<T> handler;
    private final Logger logger;
    private Addon addon;

    public Config(BentoBox plugin, Class<T> type) {
        this.logger = plugin.getLogger();
        this.handler = new YamlDatabase().getConfig(type);
    }

    public Config(Addon addon, Class<T> type) {
        this.logger = addon.getLogger();
        this.addon = addon;
        this.handler = new YamlDatabase().getConfig(type);
    }

    public List<T> loadConfigObjects() {
        List<Object> result = new ArrayList();
        try {
            result = this.handler.loadObjects();
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not load config! Error: " + e.getMessage());
        }
        return result;
    }

    public @Nullable T loadConfigObject(String uniqueId) {
        try {
            return this.handler.loadObject(uniqueId);
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BentoBox.getInstance().logError("Could not load config object! " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public @Nullable T loadConfigObject() {
        return this.loadConfigObject("");
    }

    public boolean saveConfigObject(T instance) {
        this.handler.setAddon(this.addon);
        try {
            this.handler.saveObject(instance);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not save config! Error: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean configObjectExists(String name) {
        return this.handler.objectExists(name);
    }
}

