/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.events;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.events.BentoBoxEvent;
import world.bentobox.bentobox.database.objects.Island;

public abstract class IslandBaseEvent
extends BentoBoxEvent
implements Cancellable {
    private boolean cancelled;
    protected final Island island;
    protected final UUID playerUUID;
    protected final boolean admin;
    protected final Location location;
    protected final Event rawEvent;
    protected IslandBaseEvent newEvent;

    public IslandBaseEvent(Island island) {
        this.island = island;
        this.playerUUID = island == null ? null : island.getOwner();
        this.admin = false;
        this.location = island == null ? null : island.getCenter();
        this.rawEvent = null;
    }

    public IslandBaseEvent(Island island, UUID playerUUID, boolean admin, Location location) {
        this.island = island;
        this.playerUUID = playerUUID;
        this.admin = admin;
        this.location = location != null ? location : (island != null ? island.getCenter() : null);
        this.rawEvent = null;
    }

    public IslandBaseEvent(Island island, UUID playerUUID, boolean admin, Location location, Event rawEvent) {
        this.island = island;
        this.playerUUID = playerUUID;
        this.admin = admin;
        this.location = location != null ? location : (island != null ? island.getCenter() : null);
        this.rawEvent = rawEvent;
    }

    public Island getIsland() {
        return this.island;
    }

    public UUID getOwner() {
        return this.island.getOwner();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public @Nullable Location getLocation() {
        return this.location;
    }

    public @Nullable Event getRawEvent() {
        return this.rawEvent;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public Optional<IslandBaseEvent> getNewEvent() {
        return Optional.ofNullable(this.newEvent);
    }

    public void setNewEvent(IslandBaseEvent newEvent) {
        this.newEvent = newEvent;
    }
}

