/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.events.addon;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.addon.AddonBaseEvent;
import world.bentobox.bentobox.api.events.addon.AddonDisableEvent;
import world.bentobox.bentobox.api.events.addon.AddonEnableEvent;
import world.bentobox.bentobox.api.events.addon.AddonGeneralEvent;
import world.bentobox.bentobox.api.events.addon.AddonLoadEvent;

public class AddonEvent {
    public AddonEventBuilder builder() {
        return new AddonEventBuilder(this);
    }

    public class AddonEventBuilder {
        private Addon addon;
        private Reason reason = Reason.UNKNOWN;
        private Map<String, Object> keyValues = new HashMap<String, Object>();

        public AddonEventBuilder(AddonEvent this$0) {
        }

        public AddonEventBuilder keyValues(Map<String, Object> keyValues) {
            this.keyValues = keyValues;
            return this;
        }

        public AddonEventBuilder addon(Addon addon) {
            this.addon = addon;
            return this;
        }

        public AddonEventBuilder reason(Reason reason) {
            this.reason = reason;
            return this;
        }

        private AddonBaseEvent getEvent() {
            return switch (this.reason.ordinal()) {
                case 0 -> new AddonEnableEvent(this.addon, this.keyValues);
                case 1 -> new AddonDisableEvent(this.addon, this.keyValues);
                case 2 -> new AddonLoadEvent(this.addon, this.keyValues);
                default -> new AddonGeneralEvent(this.addon, this.keyValues);
            };
        }

        public AddonBaseEvent build() {
            AddonBaseEvent newEvent = this.getEvent();
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            return newEvent;
        }
    }

    public static enum Reason {
        ENABLE,
        DISABLE,
        LOAD,
        UNKNOWN;

    }
}

