/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.flags;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.util.Util;

public abstract class FlagListener
implements Listener {
    private @NonNull BentoBox plugin = BentoBox.getInstance();
    private @Nullable User user = null;

    public @NonNull BentoBox getPlugin() {
        return this.plugin;
    }

    public void setPlugin(@NonNull BentoBox plugin) {
        this.plugin = plugin;
    }

    public void noGo(@NonNull Event e, @NonNull Flag flag) {
        this.noGo(e, flag, false, "protection.protected");
    }

    public void noGo(@NonNull Event e, @NonNull Flag flag, boolean silent, String string) {
        if (e instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)e;
            cancellable.setCancelled(true);
        }
        if (this.user != null && !silent) {
            this.user.notify(string, "[description]", this.user.getTranslation(flag.getHintReference(), new String[0]));
        }
    }

    public boolean checkIsland(@NonNull Event e, @Nullable Player player, @Nullable Location loc, @NonNull Flag flag) {
        return this.checkIsland(e, player, loc, flag, false);
    }

    public boolean checkIsland(@NonNull Event e, @Nullable Player player, @Nullable Location loc, @NonNull Flag flag, boolean silent) {
        User user = this.user = player == null ? null : User.getInstance(player);
        if (loc == null) {
            if (this.user != null && this.user.getLocation().getWorld() != null) {
                this.report(this.user, e, this.user.getLocation(), flag, Why.NULL_LOCATION);
            }
            return true;
        }
        if (!this.plugin.getIWM().inWorld(loc)) {
            this.report(this.user, e, loc, flag, Why.UNPROTECTED_WORLD);
            return true;
        }
        Optional<Island> island = this.getIslands().getProtectedIslandAt(loc);
        if (flag.getType().equals((Object)Flag.Type.SETTING)) {
            return this.processSetting(flag, island, e, loc);
        }
        if (!this.user.getMetaData("AdminCommandSwitch").map(MetaDataValue::asBoolean).orElse(false).booleanValue() && (this.user.hasPermission(this.getIWM().getPermissionPrefix(loc.getWorld()) + "mod.bypassprotect") || this.user.hasPermission(this.getIWM().getPermissionPrefix(loc.getWorld()) + "mod.bypass." + flag.getID() + ".everywhere"))) {
            if (this.user.isOp()) {
                this.report(this.user, e, loc, flag, Why.OP);
            } else {
                this.report(this.user, e, loc, flag, Why.BYPASS_EVERYWHERE);
            }
            return true;
        }
        if (flag.getType().equals((Object)Flag.Type.WORLD_SETTING)) {
            return this.processWorldSetting(flag, loc, e, silent);
        }
        User.setPlugin(this.plugin);
        if (island.isPresent()) {
            return this.processBypass(flag, island.get(), e, loc, silent);
        }
        if (flag.isSetForWorld(loc.getWorld())) {
            this.report(this.user, e, loc, flag, Why.ALLOWED_IN_WORLD);
            return true;
        }
        this.report(this.user, e, loc, flag, Why.NOT_ALLOWED_IN_WORLD);
        this.noGo(e, flag, silent, "protection.world-protected");
        return false;
    }

    private boolean processBypass(@NonNull Flag flag, Island island, @NonNull Event e, @NonNull Location loc, boolean silent) {
        if (island.isAllowed(this.user, flag)) {
            this.report(this.user, e, loc, flag, Why.RANK_ALLOWED);
            return true;
        }
        if (!this.user.getMetaData("AdminCommandSwitch").map(MetaDataValue::asBoolean).orElse(false).booleanValue() && this.user.hasPermission(this.getIWM().getPermissionPrefix(loc.getWorld()) + "mod.bypass." + flag.getID() + ".island")) {
            this.report(this.user, e, loc, flag, Why.BYPASS_ISLAND);
            return true;
        }
        this.report(this.user, e, loc, flag, Why.NOT_ALLOWED_ON_ISLAND);
        this.noGo(e, flag, silent, island.isSpawn() ? "protection.spawn-protected" : "protection.protected");
        return false;
    }

    private boolean processWorldSetting(@NonNull Flag flag, @NonNull Location loc, @NonNull Event e, boolean silent) {
        if (flag.isSetForWorld(loc.getWorld())) {
            this.report(this.user, e, loc, flag, Why.ALLOWED_IN_WORLD);
            return true;
        }
        this.report(this.user, e, loc, flag, Why.NOT_ALLOWED_IN_WORLD);
        this.noGo(e, flag, silent, "protection.world-protected");
        return false;
    }

    private boolean processSetting(@NonNull Flag flag, Optional<Island> island, @NonNull Event e, @NonNull Location loc) {
        if (island.isPresent()) {
            this.report(this.user, e, loc, flag, island.map(x -> x.isAllowed(flag)).orElse(false) != false ? Why.SETTING_ALLOWED_ON_ISLAND : Why.SETTING_NOT_ALLOWED_ON_ISLAND);
        } else {
            this.report(this.user, e, loc, flag, flag.isSetForWorld(loc.getWorld()) ? Why.SETTING_ALLOWED_IN_WORLD : Why.SETTING_NOT_ALLOWED_IN_WORLD);
        }
        return island.map(x -> x.isAllowed(flag)).orElseGet(() -> flag.isSetForWorld(loc.getWorld()));
    }

    protected void report(@Nullable User user, @NonNull Event e, @NonNull Location loc, @NonNull Flag flag, @NonNull Why why) {
        if (user != null && user.isPlayer() && user.getPlayer().getMetadata(loc.getWorld().getName() + "_why_debug").stream().filter(p -> p.getOwningPlugin().equals((Object)this.getPlugin())).findFirst().map(MetadataValue::asBoolean).orElse(false).booleanValue()) {
            User issuer;
            String whyEvent = "Why: " + e.getEventName() + " in world " + loc.getWorld().getName() + " at " + Util.xyz(loc.toVector());
            String whyBypass = "Why: " + user.getName() + " " + flag.getID() + " - " + why.name();
            this.plugin.log(whyEvent);
            this.plugin.log(whyBypass);
            String issuerUUID = user.getPlayer().getMetadata(loc.getWorld().getName() + "_why_debug_issuer").stream().filter(p -> this.getPlugin().equals(p.getOwningPlugin())).findFirst().map(MetadataValue::asString).orElse("");
            if (!issuerUUID.isEmpty() && (issuer = User.getInstance(UUID.fromString(issuerUUID))).isPlayer()) {
                user.sendRawMessage(whyEvent);
                user.sendRawMessage(whyBypass);
            }
        }
    }

    protected @NonNull Optional<Flag> getFlag(@NonNull String id) {
        return this.plugin.getFlagsManager().getFlag(id);
    }

    protected IslandsManager getIslands() {
        return this.plugin.getIslands();
    }

    protected IslandsManager getIslandsManager() {
        return this.plugin.getIslands();
    }

    protected IslandWorldManager getIWM() {
        return this.plugin.getIWM();
    }

    protected boolean PVPAllowed(Location location) {
        return this.plugin.getIslands().getIslandAt(location).map(i -> i.isAllowed(this.getFlag(location.getWorld()))).orElse(false);
    }

    protected Flag getFlag(World w) {
        return switch (w.getEnvironment()) {
            case World.Environment.NETHER -> Flags.PVP_NETHER;
            case World.Environment.THE_END -> Flags.PVP_END;
            default -> Flags.PVP_OVERWORLD;
        };
    }

    protected static enum Why {
        UNPROTECTED_WORLD,
        OP,
        BYPASS_EVERYWHERE,
        BYPASS_ISLAND,
        RANK_ALLOWED,
        ALLOWED_IN_WORLD,
        ALLOWED_ON_ISLAND,
        NOT_ALLOWED_ON_ISLAND,
        NOT_ALLOWED_IN_WORLD,
        ERROR_NO_ASSOCIATED_USER,
        NOT_SET,
        SETTING_ALLOWED_ON_ISLAND,
        SETTING_NOT_ALLOWED_ON_ISLAND,
        SETTING_ALLOWED_IN_WORLD,
        SETTING_NOT_ALLOWED_IN_WORLD,
        NULL_LOCATION;

    }
}

