/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.github.objects.repositories;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import world.bentobox.bentobox.api.github.GitHubWebAPI;
import world.bentobox.bentobox.api.github.objects.repositories.GitHubContributor;
import world.bentobox.bentobox.api.github.objects.repositories.GitHubFile;

public class GitHubRepository {
    private final GitHubWebAPI api;
    private final String fullName;

    public GitHubRepository(GitHubWebAPI api, String fullName) {
        this.api = api;
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public GitHubFile getContent(String path) throws Exception {
        return new GitHubFile(this.api, this, "/contents/" + path);
    }

    public List<GitHubContributor> getContributors() throws Exception {
        JsonArray response = this.api.fetch("repos/" + this.fullName + "/contributors").getAsJsonArray();
        ArrayList<GitHubContributor> contributors = new ArrayList<GitHubContributor>();
        response.forEach(element -> {
            JsonObject contributor = element.getAsJsonObject();
            contributors.add(new GitHubContributor(contributor.get("login").getAsString(), contributor.get("contributions").getAsInt()));
        });
        return contributors;
    }
}

