/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.logs;

import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LogEntry {
    @Expose
    private final long timestamp;
    @Expose
    private final LogType type;
    @Expose
    private final String customType;
    @Expose
    private final Map<String, String> data;

    private LogEntry(@NonNull Builder builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.data = builder.data;
        this.customType = builder.customType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public @NonNull LogType getType() {
        return this.type;
    }

    public @Nullable Map<String, String> getData() {
        return this.data;
    }

    public static class Builder {
        private long timestamp = System.currentTimeMillis();
        private final LogType type;
        private Map<String, String> data;
        private final String customType;

        public Builder(LogType type) {
            this.type = type;
            this.data = new LinkedHashMap<String, String>();
            this.customType = null;
        }

        public Builder(String customType) {
            this.type = LogType.UNKNOWN;
            this.data = new LinkedHashMap<String, String>();
            this.customType = customType;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder data(Map<String, String> data2) {
            this.data = data2;
            return this;
        }

        public Builder data(@NonNull String key, @Nullable String value) {
            this.data.put(key, value);
            return this;
        }

        public LogEntry build() {
            return new LogEntry(this);
        }
    }

    public static enum LogType {
        REMOVE,
        ADD,
        UNREGISTER,
        BAN,
        COMPELTE,
        UNOWNED,
        SPAWN,
        UNBAN,
        JOINED,
        NEWOWNER,
        TRUSTED,
        COOP,
        UNKNOWN,
        RESET,
        RESET_ALL,
        NEW,
        DUPLICATE,
        INFO;

    }
}

