/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels;

import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.PanelListener;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.listeners.PanelListenerManager;
import world.bentobox.bentobox.util.heads.HeadGetter;
import world.bentobox.bentobox.util.heads.HeadRequester;

public class Panel
implements HeadRequester,
InventoryHolder {
    private Inventory inventory;
    private Map<Integer, PanelItem> items;
    private PanelListener listener;
    private User user;
    private String name;
    private World world;
    private Island island;

    public Panel() {
    }

    public Panel(String name, Map<Integer, PanelItem> items, int size, User user, PanelListener listener) {
        this(name, items, size, user, listener, Type.INVENTORY);
    }

    public Panel(String name, Map<Integer, PanelItem> items, int size, User user, PanelListener listener, Type type) {
        this.makePanel(name, items, size, user, listener, type);
    }

    public Panel(PanelBuilder pb) {
        this.world = pb.getWorld();
        this.makePanel(pb.getName(), pb.getItems(), Math.max(pb.getSize(), pb.getItems().isEmpty() ? pb.getSize() : pb.getItems().lastKey() + 1), pb.getUser(), pb.getListener(), pb.getPanelType());
    }

    protected void makePanel(String name, Map<Integer, PanelItem> items, int size, User user, PanelListener listener) {
        this.makePanel(name, items, size, user, listener, Type.INVENTORY);
    }

    protected void makePanel(String name, Map<Integer, PanelItem> items, int size, User user, PanelListener listener, Type type) {
        this.name = name;
        this.items = items;
        switch (type.ordinal()) {
            case 0: {
                this.inventory = Bukkit.createInventory(null, (int)this.fixSize(size), (String)name);
                break;
            }
            case 1: {
                this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)name);
                break;
            }
            case 2: {
                this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.DROPPER, (String)name);
                break;
            }
            case 3: {
                this.inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.ANVIL, (String)name);
            }
        }
        for (Map.Entry<Integer, PanelItem> en : items.entrySet()) {
            if (en.getKey() >= 54) continue;
            this.inventory.setItem(en.getKey().intValue(), en.getValue().getItem());
            if (!en.getValue().isPlayerHead()) continue;
            HeadGetter.getHead(en.getValue(), this);
        }
        this.listener = listener;
        if (listener != null) {
            listener.setup();
        }
        this.user = user;
        if (user != null) {
            this.open(user);
        }
    }

    private int fixSize(int size) {
        if (size == 0) {
            size = this.items.keySet().size();
        }
        if (size > 0) {
            size += 8;
            if ((size -= size % 9) > 54) {
                size = 54;
            }
        } else {
            return 9;
        }
        return size;
    }

    public @NonNull Inventory getInventory() {
        return this.inventory;
    }

    public Map<Integer, PanelItem> getItems() {
        return this.items;
    }

    public Optional<PanelListener> getListener() {
        return Optional.ofNullable(this.listener);
    }

    public Optional<User> getUser() {
        return Optional.ofNullable(this.user);
    }

    public void open(Player ... players) {
        for (Player player : players) {
            player.openInventory(this.inventory);
            PanelListenerManager.getOpenPanels().put(player.getUniqueId(), this);
        }
    }

    public void open(User ... users) {
        for (User u : users) {
            u.getPlayer().openInventory(this.inventory);
            PanelListenerManager.getOpenPanels().put(u.getUniqueId(), this);
        }
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setItems(Map<Integer, PanelItem> items) {
        this.items = items;
    }

    public void setListener(PanelListener listener) {
        this.listener = listener;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void setHead(PanelItem item) {
        this.items.entrySet().stream().filter(entry -> entry.getValue() == item).mapToInt(Map.Entry::getKey).findFirst().ifPresent(index -> this.inventory.setItem(index, item.getItem()));
    }

    public String getName() {
        return this.name;
    }

    public Optional<World> getWorld() {
        return Optional.ofNullable(this.world);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public Island getIsland() {
        return this.island;
    }

    public void setIsland(Island island) {
        this.island = island;
    }

    public static enum Type {
        INVENTORY,
        HOPPER,
        DROPPER,
        ANVIL;

    }
}

