/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.PanelListener;
import world.bentobox.bentobox.api.panels.Tab;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TabbedPanelBuilder;
import world.bentobox.bentobox.api.user.User;

public class TabbedPanel
extends Panel
implements PanelListener {
    private static final String PROTECTION_PANEL = "protection.panel.";
    private static final long ITEMS_PER_PAGE = 36L;
    private final TabbedPanelBuilder tpb;
    private final @NonNull BentoBox plugin = BentoBox.getInstance();
    private int activeTab;
    private int activePage;
    private boolean closed;

    public TabbedPanel(TabbedPanelBuilder tpb) {
        this.tpb = tpb;
        this.setWorld(tpb.getWorld());
        this.setIsland(tpb.getIsland());
    }

    @Override
    public void refreshPanel() {
        if (this.closed) {
            return;
        }
        this.openPanel(this.activeTab, this.activePage);
        this.closed = false;
    }

    public void openPanel() {
        this.openPanel(this.tpb.getStartingSlot(), 0);
    }

    public void openPanel(int activeTab, int page) {
        if (!this.tpb.getTabs().containsKey(activeTab)) {
            throw new InvalidParameterException("Attempt to open a non-existent tab in a tabbed panel. Missing tab #" + activeTab);
        }
        if (page < 0) {
            throw new InvalidParameterException("Attempt to open a tab in a tabbed panel to a negative page! " + page);
        }
        this.activeTab = activeTab;
        this.activePage = page;
        TreeMap<Integer, PanelItem> items = new TreeMap<Integer, PanelItem>();
        Tab tab = this.tpb.getTabs().get(activeTab);
        if (this.tpb.isHideIfEmpty()) {
            this.tpb.getTabs().values().removeIf(t -> !t.equals(tab) && t.getPanelItems().stream().noneMatch(Objects::nonNull));
        }
        this.setupHeader(tab, items);
        if (this.tpb.getTabs().containsKey(activeTab)) {
            List<PanelItem> panelItems = tab.getPanelItems();
            panelItems.stream().filter(Objects::nonNull).skip((long)page * 36L).limit((long)page * 36L + 36L).forEach(i -> items.put((Integer)items.lastKey() + 1, (PanelItem)i));
            this.setupFooter(items);
            if (page > 0) {
                items.put(46, new PanelItemBuilder().icon(Material.ARROW).name(this.tpb.getUser().getTranslation("protection.panel.previous", new String[0])).clickHandler((panel, user1, clickType, slot1) -> {
                    --this.activePage;
                    this.refreshPanel();
                    return true;
                }).build());
            }
            if ((long)(page + 1) * 36L < panelItems.stream().filter(Objects::nonNull).count()) {
                items.put(52, new PanelItemBuilder().icon(Material.ARROW).name(this.tpb.getUser().getTranslation("protection.panel.next", new String[0])).clickHandler((panel, user1, clickType, slot1) -> {
                    ++this.activePage;
                    this.refreshPanel();
                    return true;
                }).build());
            }
        } else {
            throw new InvalidParameterException("Unknown tab slot number " + activeTab);
        }
        this.makePanel(tab.getName(), items, this.tpb.getSize(), this.tpb.getUser(), this);
    }

    private void setupHeader(Tab tab, TreeMap<Integer, PanelItem> items) {
        for (int i = 0; i < 9; ++i) {
            items.put(i, new PanelItemBuilder().icon(this.plugin.getSettings().getPanelFillerMaterial()).name(" ").build());
        }
        for (Map.Entry<Integer, Tab> tabPanel : this.tpb.getTabs().entrySet()) {
            if (!this.tpb.getUser().hasPermission(tabPanel.getValue().getPermission())) continue;
            PanelItem activeIcon = tabPanel.getValue().getIcon();
            activeIcon.setGlow(tabPanel.getValue().equals(tab));
            items.put(tabPanel.getKey(), activeIcon);
        }
        items.putAll(tab.getTabIcons());
    }

    private void setupFooter(TreeMap<Integer, PanelItem> items) {
        for (int i = 45; i < 54; ++i) {
            items.put(i, new PanelItemBuilder().icon(this.plugin.getSettings().getPanelFillerMaterial()).name(" ").build());
        }
    }

    @Override
    public void setup() {
    }

    @Override
    public void onInventoryClose(InventoryCloseEvent event) {
        this.closed = true;
    }

    @Override
    public void onInventoryClick(User user, InventoryClickEvent event) {
        if (event.isLeftClick() && this.tpb.getTabs().containsKey(event.getRawSlot()) && (this.tpb.getTabs().get(event.getRawSlot()).getPermission().isEmpty() || this.tpb.getUser().hasPermission(this.tpb.getTabs().get(event.getRawSlot()).getPermission()) || this.tpb.getUser().isOp())) {
            event.setCancelled(true);
            this.openPanel(event.getRawSlot(), 0);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
            this.closed = false;
        }
    }

    public Tab getActiveTab() {
        return this.tpb.getTabs().get(this.activeTab);
    }

    public int getActivePage() {
        return this.activePage;
    }

    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }

    public void setActiveTab(int activeTab) {
        this.activeTab = activeTab;
    }
}

