/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.user;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.user.User;

public class Notifier {
    private static final int NOTIFICATION_DELAY = 4;
    private final LoadingCache<User, Notification> notificationCache = CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.SECONDS).maximumSize(500L).build((CacheLoader)new CacheLoader<User, Notification>(this){

        public Notification load(@NonNull User user) {
            return new Notification(null, 0L);
        }
    });

    public synchronized boolean notify(User user, String message) {
        try {
            Notification lastNotification = (Notification)this.notificationCache.get((Object)user);
            long now = System.currentTimeMillis();
            if (now >= lastNotification.time() + 4000L || !message.equals(lastNotification.message())) {
                this.notificationCache.put((Object)user, (Object)new Notification(message, now));
                user.sendRawMessage(message);
                return true;
            }
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private record Notification(String message, long time) {
    }
}

