/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.nms.PasteHandler;
import world.bentobox.bentobox.nms.fallback.PasteHandlerImpl;
import world.bentobox.bentobox.util.Util;

public class BlueprintPaster {
    private static long chunkLoadTime = 0L;
    private final BentoBox plugin;
    private final PasteHandler paster = Util.getPasteHandler();
    private final PasteHandler fallback = new PasteHandlerImpl();
    private final World world;
    private Location pos1;
    private Location pos2;
    private PasteState pasteState;
    private BukkitTask pastingTask;
    private BlueprintClipboard clipboard;
    private CompletableFuture<Void> currentTask = CompletableFuture.completedFuture(null);
    private boolean sink;
    private final @NonNull Blueprint blueprint;
    private @NonNull Location location;
    private final @Nullable Island island;

    public BlueprintPaster(@NonNull BentoBox plugin, @NonNull BlueprintClipboard clipboard, @NonNull Location location) {
        this.plugin = plugin;
        this.clipboard = clipboard;
        this.blueprint = Objects.requireNonNull(clipboard.getBlueprint(), "Clipboard cannot have a null Blueprint");
        this.location = location;
        this.world = location.getWorld();
        this.island = null;
    }

    public BlueprintPaster(@NonNull BentoBox plugin, @NonNull Blueprint bp, World world, @NonNull Island island) {
        this.plugin = plugin;
        this.blueprint = bp;
        this.island = island;
        this.world = world;
        Vector off = bp.getBedrock() != null ? bp.getBedrock() : new Vector(0, 0, 0);
        this.location = island.getProtectionCenter().toVector().subtract(off).toLocation(world);
        int y = Math.min(world.getMaxHeight() - 1, Math.max(world.getMinHeight(), this.location.getBlockY()));
        this.location.setY((double)y);
    }

    public CompletableFuture<Boolean> paste() {
        return this.paste(true);
    }

    public CompletableFuture<Boolean> paste(boolean useNMS) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Map<Vector, BlueprintBlock> blocks = this.blueprint.getBlocks() == null ? Collections.emptyMap() : this.blueprint.getBlocks();
        Map<Vector, BlueprintBlock> attached = this.blueprint.getAttached() == null ? Collections.emptyMap() : this.blueprint.getAttached();
        Map<Vector, List<BlueprintEntity>> entities = this.blueprint.getEntities() == null ? Collections.emptyMap() : this.blueprint.getEntities();
        this.pasteState = PasteState.CHUNK_LOAD;
        Optional<User> owner = Optional.ofNullable(this.island).map(i -> User.getInstance(i.getOwner()));
        owner.ifPresent(user -> this.tellOwner((User)user, blocks.size(), attached.size(), entities.size(), this.plugin.getSettings().getPasteSpeed()));
        Bits bits = new Bits(blocks, attached, entities, blocks.entrySet().iterator(), attached.entrySet().iterator(), entities.entrySet().iterator(), this.plugin.getSettings().getPasteSpeed());
        this.pastingTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.pasterTask(result, owner, bits, useNMS), 0L, 1L);
        return result;
    }

    private void pasterTask(CompletableFuture<Boolean> result, Optional<User> owner, Bits bits, boolean useNMS) {
        if (!this.currentTask.isDone()) {
            return;
        }
        int pasteSpeed = this.plugin.getSettings().getPasteSpeed();
        int count = 0;
        if (this.pasteState.equals((Object)PasteState.CHUNK_LOAD)) {
            this.loadChunk();
        } else if (this.pasteState.equals((Object)PasteState.BLOCKS) || this.pasteState.equals((Object)PasteState.ATTACHMENTS)) {
            this.pasteBlocks(bits, count, owner, pasteSpeed, useNMS);
        } else if (this.pasteState.equals((Object)PasteState.ENTITIES)) {
            this.pasteEntities(bits, count, owner, pasteSpeed, useNMS);
        } else if (this.pasteState.equals((Object)PasteState.DONE)) {
            this.cancelTask(result);
        } else if (this.pasteState.equals((Object)PasteState.CANCEL)) {
            this.pastingTask.cancel();
            result.complete(true);
        }
    }

    private void cancelTask(CompletableFuture<Boolean> result) {
        if (this.island == null && this.clipboard != null) {
            this.clipboard.setPos1(this.pos1);
            this.clipboard.setPos2(this.pos2);
        }
        this.pasteState = PasteState.CANCEL;
        result.complete(true);
    }

    private void pasteEntities(Bits bits, int count, Optional<User> owner, int pasteSpeed, boolean useNMS) {
        if (bits.it3().hasNext()) {
            HashMap<Location, List<BlueprintEntity>> entityMap = new HashMap<Location, List<BlueprintEntity>>();
            while (count < pasteSpeed && bits.it3().hasNext()) {
                Map.Entry<Vector, List<BlueprintEntity>> entry = bits.it3().next();
                int x = this.location.getBlockX() + entry.getKey().getBlockX();
                int y = this.location.getBlockY() + entry.getKey().getBlockY();
                int z = this.location.getBlockZ() + entry.getKey().getBlockZ();
                Location center = new Location(this.world, (double)x, (double)y, (double)z).add(new Vector(0.5, 0.0, 0.5));
                List<BlueprintEntity> entities = entry.getValue();
                entityMap.put(center, entities);
                ++count;
            }
            if (!entityMap.isEmpty()) {
                this.currentTask = useNMS ? this.paster.pasteEntities(this.island, this.world, entityMap) : this.fallback.pasteEntities(this.island, this.world, entityMap);
            }
        } else {
            this.pasteState = PasteState.DONE;
            String dimensionType = switch (this.location.getWorld().getEnvironment()) {
                case World.Environment.NETHER -> owner.map(user -> user.getTranslation("general.worlds.nether", new String[0])).orElse("");
                case World.Environment.THE_END -> owner.map(user -> user.getTranslation("general.worlds.the-end", new String[0])).orElse("");
                default -> owner.map(user -> user.getTranslation("general.worlds.overworld", new String[0])).orElse("");
            };
            owner.ifPresent(user -> user.sendMessage("commands.island.create.pasting.dimension-done", "[world]", dimensionType));
        }
    }

    private void pasteBlocks(Bits bits, int count, Optional<User> owner, int pasteSpeed, boolean useNMS) {
        Iterator<Map.Entry<Vector, BlueprintBlock>> it;
        Iterator<Map.Entry<Vector, BlueprintBlock>> iterator = it = this.pasteState.equals((Object)PasteState.BLOCKS) ? bits.it : bits.it2;
        if (it.hasNext()) {
            this.pasteBlocksNow(it, count, pasteSpeed, useNMS);
        } else if (this.pasteState.equals((Object)PasteState.BLOCKS)) {
            this.pasteState = PasteState.ATTACHMENTS;
        } else {
            this.pasteState = PasteState.ENTITIES;
            if (bits.entities.size() != 0) {
                owner.ifPresent(user -> user.sendMessage("commands.island.create.pasting.entities", "[number]", String.valueOf(bits.entities.size())));
            }
        }
    }

    private void pasteBlocksNow(Iterator<Map.Entry<Vector, BlueprintBlock>> it, int count, int pasteSpeed, boolean useNMS) {
        HashMap<Location, BlueprintBlock> blockMap = new HashMap<Location, BlueprintBlock>();
        while (count < pasteSpeed && it.hasNext()) {
            Map.Entry<Vector, BlueprintBlock> entry = it.next();
            Location pasteTo = this.location.clone().add(entry.getKey());
            this.updatePos(pasteTo);
            BlueprintBlock block = entry.getValue();
            blockMap.put(pasteTo, block);
            ++count;
        }
        if (!blockMap.isEmpty()) {
            this.currentTask = useNMS ? this.paster.pasteBlocks(this.island, this.world, blockMap) : this.fallback.pasteBlocks(this.island, this.world, blockMap);
        }
    }

    private void loadChunk() {
        long timer = System.currentTimeMillis();
        this.pasteState = PasteState.CHUNK_LOADING;
        this.currentTask = Util.getChunkAtAsync(this.location).thenRun(() -> {
            this.pasteState = PasteState.BLOCKS;
            long duration = System.currentTimeMillis() - timer;
            if (duration > chunkLoadTime) {
                chunkLoadTime = duration;
            }
            if (this.blueprint.isSink() && !this.sink) {
                this.sink = true;
                this.location = new Location(this.location.getWorld(), this.location.getX(), (double)this.location.getWorld().getHighestBlockYAt(this.location, HeightMap.OCEAN_FLOOR), this.location.getZ());
            }
        });
    }

    private void tellOwner(User user, int blocksSize, int attachedSize, int entitiesSize, int pasteSpeed) {
        double total = (double)blocksSize + (double)attachedSize + (double)entitiesSize;
        BigDecimal time = BigDecimal.valueOf(total / ((double)pasteSpeed * 20.0) + (double)chunkLoadTime / 1000.0).setScale(1, RoundingMode.UP);
        user.sendMessage("commands.island.create.pasting.estimated-time", "[number]", String.valueOf(time.doubleValue()));
        user.sendMessage("commands.island.create.pasting.blocks", "[number]", String.valueOf(blocksSize + attachedSize));
    }

    private void updatePos(Location l) {
        if (this.pos1 == null) {
            this.pos1 = l.clone();
        }
        if (this.pos2 == null) {
            this.pos2 = l.clone();
        }
        if (l.getBlockX() < this.pos1.getBlockX()) {
            this.pos1.setX((double)l.getBlockX());
        }
        if (l.getBlockX() > this.pos2.getBlockX()) {
            this.pos2.setX((double)l.getBlockX());
        }
        if (l.getBlockY() < this.pos1.getBlockY()) {
            this.pos1.setY((double)l.getBlockY());
        }
        if (l.getBlockY() > this.pos2.getBlockY()) {
            this.pos2.setY((double)l.getBlockY());
        }
        if (l.getBlockZ() < this.pos1.getBlockZ()) {
            this.pos1.setZ((double)l.getBlockZ());
        }
        if (l.getBlockZ() > this.pos2.getBlockZ()) {
            this.pos2.setZ((double)l.getBlockZ());
        }
    }

    static enum PasteState {
        CHUNK_LOAD,
        CHUNK_LOADING,
        BLOCKS,
        ATTACHMENTS,
        ENTITIES,
        DONE,
        CANCEL;

    }

    private record Bits(Map<Vector, BlueprintBlock> blocks, Map<Vector, BlueprintBlock> attached, Map<Vector, List<BlueprintEntity>> entities, Iterator<Map.Entry<Vector, BlueprintBlock>> it, Iterator<Map.Entry<Vector, BlueprintBlock>> it2, Iterator<Map.Entry<Vector, List<BlueprintEntity>>> it3, int pasteSpeed) {
    }
}

