/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints.conversation;

import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.conversation.NameSuccessPrompt;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.util.Util;

public class NamePrompt
extends StringPrompt {
    private final GameModeAddon addon;
    private final @Nullable BlueprintBundle bb;
    private @Nullable Blueprint bp;

    public NamePrompt(@NonNull GameModeAddon addon, @Nullable BlueprintBundle bb) {
        this.addon = addon;
        this.bb = bb;
    }

    public NamePrompt(@NonNull GameModeAddon addon, @Nullable Blueprint bp, @Nullable BlueprintBundle bb) {
        this.addon = addon;
        this.bp = bp;
        this.bb = bb;
    }

    public @NonNull String getPromptText(ConversationContext context) {
        User user = User.getInstance((Player)context.getForWhom());
        return user.getTranslation("commands.admin.blueprint.management.name.prompt", new String[0]);
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        User user = User.getInstance((Player)context.getForWhom());
        String uniqueId = Util.sanitizeInput(input);
        if (Util.stripColor(Util.translateColorCodes(input)).length() > 32) {
            context.getForWhom().sendRawMessage(user.getTranslation("commands.admin.blueprint.management.name.too-long", new String[0]));
            return this;
        }
        if (this.bb == null || !this.bb.getUniqueId().equals("default")) {
            if (this.addon.getPlugin().getBlueprintsManager().getBlueprintBundles(this.addon).containsKey(uniqueId)) {
                context.getForWhom().sendRawMessage(user.getTranslation("commands.admin.blueprint.management.name.pick-a-unique-name", new String[0]));
                return this;
            }
            context.setSessionData((Object)"uniqueId", (Object)uniqueId);
        } else {
            context.setSessionData((Object)"uniqueId", (Object)this.bb.getUniqueId());
        }
        context.setSessionData((Object)"name", (Object)input);
        return new NameSuccessPrompt(this.addon, this.bb, this.bp);
    }
}

