/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints.dataobjects;

import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.spawner.TrialSpawnerConfiguration;
import org.jetbrains.annotations.NotNull;

public class BlueprintTrialSpawner {
    @Expose
    private boolean ominous;
    @Expose
    private EntityType spawnedType;
    @Expose
    private double addSimulEnts;
    @Expose
    private double addSpawnsB4Cool;
    @Expose
    private double baseSimEnts;
    @Expose
    private int delay;
    @Expose
    @NotNull
    private Map<LootTableSerial, Integer> lootTableMap = new HashMap<LootTableSerial, Integer>();
    @Expose
    private int spawnRange;
    @Expose
    private int requiredPlayerRange;
    @Expose
    private int playerRange;
    @Expose
    private double baseSpawnsB4Cool;
    @Expose
    private List<PotentialSpawns> potentialSpawns;

    public BlueprintTrialSpawner(boolean ominous, TrialSpawnerConfiguration spawner) {
        this.ominous = ominous;
        this.addSimulEnts = spawner.getAdditionalSimultaneousEntities();
        this.addSpawnsB4Cool = spawner.getAdditionalSpawnsBeforeCooldown();
        this.baseSimEnts = spawner.getBaseSimultaneousEntities();
        this.baseSpawnsB4Cool = spawner.getBaseSpawnsBeforeCooldown();
        this.lootTableMap = this.convertToLootTableSerial(spawner.getPossibleRewards());
        this.spawnRange = spawner.getSpawnRange();
        this.requiredPlayerRange = spawner.getRequiredPlayerRange();
        this.potentialSpawns = spawner.getPotentialSpawns().stream().map(se -> {
            EntitySnapshot snapshot = se.getSnapshot();
            SpawnRule spawnRule = se.getSpawnRule();
            return new PotentialSpawns(snapshot.getAsString(), spawnRule == null ? null : spawnRule.serialize(), se.getSpawnWeight());
        }).toList();
        if (this.potentialSpawns.isEmpty()) {
            this.potentialSpawns = null;
            this.spawnedType = spawner.getSpawnedType();
        }
    }

    private Map<LootTableSerial, Integer> convertToLootTableSerial(Map<LootTable, Integer> possibleRewards) {
        return possibleRewards.entrySet().stream().collect(Collectors.toMap(entry -> {
            NamespacedKey key = ((LootTable)entry.getKey()).getKey();
            return new LootTableSerial(key.getNamespace(), key.getKey());
        }, Map.Entry::getValue));
    }

    private Map<LootTable, Integer> convertToLootTable(Map<LootTableSerial, Integer> serializedRewards) {
        HashMap<LootTable, Integer> result = new HashMap<LootTable, Integer>();
        for (Map.Entry<LootTableSerial, Integer> entry : serializedRewards.entrySet()) {
            LootTableSerial lootTableSerial = entry.getKey();
            Integer value = Math.max(1, entry.getValue());
            NamespacedKey key = new NamespacedKey(lootTableSerial.nameSpace(), lootTableSerial.key());
            LootTable lootTable = Bukkit.getLootTable((NamespacedKey)key);
            if (lootTable != null) {
                result.put(lootTable, value);
                continue;
            }
            System.err.println("LootTable not found for key: " + String.valueOf(key));
        }
        return result;
    }

    public boolean configTrialSpawner(TrialSpawnerConfiguration spawner) {
        spawner.setAdditionalSimultaneousEntities((float)this.addSimulEnts);
        spawner.setAdditionalSpawnsBeforeCooldown((float)this.addSpawnsB4Cool);
        spawner.setBaseSimultaneousEntities((float)this.baseSimEnts);
        spawner.setBaseSpawnsBeforeCooldown((float)this.baseSpawnsB4Cool);
        spawner.setDelay(this.delay);
        spawner.setSpawnRange(this.spawnRange);
        spawner.setPossibleRewards(this.convertToLootTable(this.lootTableMap));
        spawner.setRequiredPlayerRange(this.requiredPlayerRange);
        if (this.spawnedType != null) {
            spawner.setSpawnedType(this.spawnedType);
        } else {
            spawner.setPotentialSpawns((Collection)this.potentialSpawns.stream().map(ps -> {
                EntitySnapshot snapshot = Bukkit.getEntityFactory().createEntitySnapshot(ps.snapshot());
                SpawnRule rule = ps.spawnrule() != null ? SpawnRule.deserialize(ps.spawnrule()) : null;
                return new SpawnerEntry(snapshot, ps.spawnWeight(), rule);
            }).collect(Collectors.toList()));
        }
        return this.isOminous();
    }

    public boolean isOminous() {
        return this.ominous;
    }

    public void setOminous(boolean ominous) {
        this.ominous = ominous;
    }

    public EntityType getSpawnedType() {
        return this.spawnedType;
    }

    public void setSpawnedType(EntityType spawnedType) {
        this.spawnedType = spawnedType;
    }

    public double getAddSimulEnts() {
        return this.addSimulEnts;
    }

    public void setAddSimulEnts(double addSimulEnts) {
        this.addSimulEnts = addSimulEnts;
    }

    public double getAddSpawnsB4Cool() {
        return this.addSpawnsB4Cool;
    }

    public void setAddSpawnsB4Cool(double addSpawnsB4Cool) {
        this.addSpawnsB4Cool = addSpawnsB4Cool;
    }

    public double getBaseSimEnts() {
        return this.baseSimEnts;
    }

    public void setBaseSimEnts(double baseSimEnts) {
        this.baseSimEnts = baseSimEnts;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public Map<LootTableSerial, Integer> getLootTableMap() {
        return this.lootTableMap;
    }

    public void setLootTableMap(Map<LootTableSerial, Integer> lootTableMap) {
        this.lootTableMap = lootTableMap;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public int getPlayerRange() {
        return this.playerRange;
    }

    public void setPlayerRange(int playerRange) {
        this.playerRange = playerRange;
    }

    public double getBaseSpawnsB4Cool() {
        return this.baseSpawnsB4Cool;
    }

    public void setBaseSpawnsB4Cool(double baseSpawnsB4Cool) {
        this.baseSpawnsB4Cool = baseSpawnsB4Cool;
    }

    public String toString() {
        return "BlueprintTrialSpawner [ominous=" + this.ominous + ", " + (String)(this.spawnedType != null ? "spawnedType=" + String.valueOf(this.spawnedType) + ", " : "") + "addSimulEnts=" + this.addSimulEnts + ", addSpawnsB4Cool=" + this.addSpawnsB4Cool + ", baseSimEnts=" + this.baseSimEnts + ", delay=" + this.delay + ", " + (String)(this.lootTableMap != null ? "lootTableMap=" + String.valueOf(this.lootTableMap) + ", " : "") + "spawnRange=" + this.spawnRange + ", requiredPlayerRange=" + this.requiredPlayerRange + ", playerRange=" + this.playerRange + ", baseSpawnsB4Cool=" + this.baseSpawnsB4Cool + "]";
    }

    record LootTableSerial(@Expose String nameSpace, @Expose String key) {
    }

    record PotentialSpawns(@Expose String snapshot, @Expose Map<String, Object> spawnrule, @Expose int spawnWeight) {
    }
}

