/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.commands;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;

public class BentoBoxPermsCommand
extends CompositeCommand {
    public BentoBoxPermsCommand(CompositeCommand parent) {
        super(parent, "perms", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("bentobox.admin.perms");
        this.setParametersHelp("commands.bentobox.perms.parameters");
        this.setDescription("commands.bentobox.perms.description");
        this.setOnlyConsole(true);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        this.getPlugin().getCommandsManager().getCommands().values().stream().distinct().forEach(cc -> {
            if (cc.getAddon() == null) {
                user.sendMessage("*** BentoBox effective perms:", new String[0]);
            } else {
                Object patt0$temp = cc.getAddon();
                if (patt0$temp instanceof GameModeAddon) {
                    GameModeAddon gma = (GameModeAddon)patt0$temp;
                    user.sendRawMessage("**** " + gma.getDescription().getName() + " effective perms:");
                } else {
                    user.sendRawMessage("**** " + ((Addon)cc.getAddon()).getDescription().getName() + " effective perms:");
                }
            }
            user.sendRawMessage("permissions:");
            this.printData(user, (CompositeCommand)cc, cc.getLabel());
            this.printSubCommandData(user, (CompositeCommand)cc, cc.getLabel());
        });
        return true;
    }

    private void printData(User user, CompositeCommand cc, String label) {
        if (cc.getPermission().isBlank()) {
            return;
        }
        String desc = user.getTranslation(cc.getWorld(), cc.getDescription(), new String[0]);
        user.sendRawMessage("  " + cc.getPermission() + ":");
        user.sendRawMessage("    description: Allow use of '/" + label + "' command - " + desc);
        Permission p = Bukkit.getPluginManager().getPermission(cc.getPermission());
        if (p != null) {
            user.sendRawMessage("    default: " + p.getDefault().name());
        } else {
            user.sendRawMessage("    default: OP");
        }
    }

    private void printSubCommandData(User user, CompositeCommand parent, String label) {
        for (CompositeCommand cc : parent.getSubCommands().values()) {
            if (cc.getLabel().equalsIgnoreCase("help")) continue;
            String newLabel = label + " " + cc.getLabel();
            this.printData(user, cc, newLabel);
            this.printSubCommandData(user, cc, newLabel);
        }
    }
}

