/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.managers.RanksManager;

public class BentoBoxRankCommand
extends CompositeCommand {
    private static final String REMOVE = "remove";
    private int rankValue;
    private String firstElement;

    public BentoBoxRankCommand(CompositeCommand parent) {
        super(parent, "rank", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("bentobox.admin.rank");
        this.setDescription("commands.bentobox.rank.description");
        this.setParametersHelp("commands.bentobox.rank.parameters");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        this.firstElement = args.get(0);
        if (!("list".equals(this.firstElement) || "add".equals(this.firstElement) || REMOVE.equals(this.firstElement))) {
            this.showHelp(this, user);
            return false;
        }
        if (REMOVE.equals(this.firstElement) && args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        if ("add".equals(this.firstElement)) {
            if (args.size() < 3) {
                this.showHelp(this, user);
                return false;
            }
            String thirdElement = args.get(2);
            try {
                this.rankValue = Integer.parseInt(thirdElement);
            }
            catch (NumberFormatException e) {
                this.showHelp(this, user);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(User user, String label, List<String> args) {
        if ("list".equals(this.firstElement)) {
            this.showRanks(user);
            return true;
        }
        if ("add".equals(this.firstElement)) {
            if (RanksManager.getInstance().addRank(args.get(1), this.rankValue)) {
                user.sendMessage("commands.bentobox.rank.add.success", "[rank]", args.get(1), "[number]", String.valueOf(this.rankValue));
                this.showRanks(user);
                return true;
            }
            user.sendMessage("commands.bentobox.rank.add.failure", "[rank]", args.get(1), "[number]", String.valueOf(this.rankValue));
            return false;
        }
        if (RanksManager.getInstance().removeRank(args.get(1))) {
            user.sendMessage("commands.bentobox.rank.remove.success", "[rank]", args.get(1));
            this.showRanks(user);
            return true;
        }
        user.sendMessage("commands.bentobox.rank.remove.failure", "[rank]", args.get(1));
        return false;
    }

    private void showRanks(User user) {
        user.sendMessage("commands.bentobox.rank.list", new String[0]);
        RanksManager.getInstance().getRanks().forEach((ref, rank) -> user.sendRawMessage(user.getTranslation((String)ref, new String[0]) + ": " + ref + " " + String.valueOf(rank)));
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        if (args.size() <= 1) {
            return Optional.empty();
        }
        this.firstElement = args.get(1);
        if (args.size() <= 2) {
            return Optional.of(List.of("add", REMOVE, "list"));
        }
        if (args.size() > 1 && "add".equals(this.firstElement)) {
            ArrayList<String> options = new ArrayList<String>(RanksManager.DEFAULT_RANKS.keySet());
            options.removeIf(RanksManager.getInstance().getRanks().keySet()::contains);
            return Optional.of(options);
        }
        if (args.size() > 1 && REMOVE.equals(this.firstElement)) {
            return Optional.of(new ArrayList<String>(RanksManager.getInstance().getRanks().keySet()));
        }
        return Optional.empty();
    }
}

