/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.common.base.Enums;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public final class MaterialTypeAdapter
extends TypeAdapter<Material> {
    final Map<String, Material> materialMap = new HashMap<String, Material>();

    public MaterialTypeAdapter() {
        Arrays.stream(Material.values()).forEach(mat -> this.materialMap.put(mat.name(), (Material)mat));
        if (Enums.getIfPresent(Material.class, (String)"SHORT_GRASS").isPresent()) {
            this.materialMap.put("GRASS", Material.SHORT_GRASS);
        }
    }

    public Material read(JsonReader input) throws IOException {
        if (JsonToken.NULL.equals((Object)input.peek())) {
            input.nextNull();
            return null;
        }
        return this.materialMap.get(input.nextString().toUpperCase());
    }

    public void write(JsonWriter output, Material enumValue) throws IOException {
        output.value(enumValue != null ? enumValue.name() : null);
    }
}

