/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.mongodb;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.DatabaseSetup;
import world.bentobox.bentobox.database.mongodb.MongoDBDatabaseConnector;
import world.bentobox.bentobox.database.mongodb.MongoDBDatabaseHandler;

public class MongoDBDatabase
implements DatabaseSetup {
    private MongoDBDatabaseConnector connector;

    @Override
    public <T> AbstractDatabaseHandler<T> getHandler(Class<T> type) {
        BentoBox plugin = BentoBox.getInstance();
        if (Bukkit.getPluginManager().getPlugin("BsbMongo") == null) {
            plugin.logError("You must install BsbMongo plugin for MongoDB support!");
            plugin.logError("See: https://github.com/tastybento/bsbMongo/releases/");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            return null;
        }
        if (this.connector == null) {
            this.connector = new MongoDBDatabaseConnector(new DatabaseConnectionSettingsImpl(plugin.getSettings().getDatabaseHost(), plugin.getSettings().getDatabasePort(), plugin.getSettings().getDatabaseName(), plugin.getSettings().getDatabaseUsername(), plugin.getSettings().getDatabasePassword(), plugin.getSettings().isUseSSL()), plugin.getSettings().getMongodbConnectionUri());
        }
        return new MongoDBDatabaseHandler<T>(plugin, type, this.connector);
    }
}

