/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.database.DatabaseConnectionSettingsImpl;
import world.bentobox.bentobox.database.DatabaseConnector;

public class MongoDBDatabaseConnector
implements DatabaseConnector {
    private MongoClient client;
    private final DatabaseConnectionSettingsImpl dbSettings;
    private final String mongoDbConnectionURI;
    private final Set<Class<?>> types = new HashSet();

    MongoDBDatabaseConnector(DatabaseConnectionSettingsImpl dbSettings, String mongoDbConnectionURI) {
        this.dbSettings = dbSettings;
        this.mongoDbConnectionURI = mongoDbConnectionURI;
    }

    public MongoDatabase createConnection(Class<?> type) {
        this.types.add(type);
        if (this.client == null) {
            if (this.mongoDbConnectionURI == null || this.mongoDbConnectionURI.isEmpty()) {
                MongoCredential credential = MongoCredential.createCredential((String)this.dbSettings.getUsername(), (String)this.dbSettings.getDatabaseName(), (char[])this.dbSettings.getPassword().toCharArray());
                MongoClientOptions options = MongoClientOptions.builder().sslEnabled(this.dbSettings.isUseSSL()).build();
                this.client = new MongoClient(new ServerAddress(this.dbSettings.getHost(), this.dbSettings.getPort()), credential, options);
            } else {
                this.client = new MongoClient(new MongoClientURI(this.mongoDbConnectionURI));
            }
        }
        return this.client.getDatabase(this.dbSettings.getDatabaseName());
    }

    @Override
    public String getConnectionUrl() {
        return "";
    }

    @Override
    public @NonNull String getUniqueId(String tableName) {
        return "";
    }

    @Override
    public boolean uniqueIdExists(String tableName, String key) {
        return false;
    }

    @Override
    public void closeConnection(Class<?> type) {
        this.types.remove(type);
        if (this.types.isEmpty() && this.client != null) {
            this.client.close();
            Bukkit.getLogger().info("Closed database connection");
        }
    }
}

