/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.sql.sqlite;

import java.io.File;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.DatabaseSetup;
import world.bentobox.bentobox.database.sql.sqlite.SQLiteDatabaseConnector;
import world.bentobox.bentobox.database.sql.sqlite.SQLiteDatabaseHandler;

public class SQLiteDatabase
implements DatabaseSetup {
    private static final String DATABASE_FOLDER_NAME = "database";
    private SQLiteDatabaseConnector connector;

    @Override
    public <T> AbstractDatabaseHandler<T> getHandler(Class<T> dataObjectClass) {
        if (this.connector == null) {
            BentoBox plugin = BentoBox.getInstance();
            File dataFolder = new File(plugin.getDataFolder(), DATABASE_FOLDER_NAME);
            if (!dataFolder.exists() && !dataFolder.mkdirs()) {
                plugin.logError("Could not create database folder!");
                plugin.onDisable();
                return null;
            }
            this.connector = new SQLiteDatabaseConnector("jdbc:sqlite:" + dataFolder.getAbsolutePath() + File.separator + "database.db");
        }
        return new SQLiteDatabaseHandler<T>(BentoBox.getInstance(), dataObjectClass, this.connector);
    }
}

