/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.yaml;

import com.google.common.base.Enums;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.DatabaseConnector;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.AdapterInterface;
import world.bentobox.bentobox.database.yaml.YamlDatabaseConnector;
import world.bentobox.bentobox.util.Util;

public class YamlDatabaseHandler<T>
extends AbstractDatabaseHandler<T> {
    private static final String YML = ".yml";
    protected boolean configFlag;

    YamlDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector databaseConnector) {
        super(plugin, type, databaseConnector);
    }

    @Override
    public T loadObject(@NonNull String key) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException {
        Object path = "database" + File.separator + this.dataObject.getSimpleName();
        StoreAt storeAt = this.dataObject.getAnnotation(StoreAt.class);
        if (storeAt != null) {
            path = storeAt.path();
            key = storeAt.filename();
        }
        YamlConfiguration config = ((YamlDatabaseConnector)this.databaseConnector).loadYamlFile((String)path, key);
        return this.createObject(config);
    }

    @Override
    public boolean objectExists(String uniqueId) {
        return this.databaseConnector.uniqueIdExists(this.dataObject.getSimpleName(), uniqueId);
    }

    @Override
    public List<T> loadObjects() throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException {
        File dataFolder;
        File tableFolder;
        ArrayList<T> list = new ArrayList<T>();
        FilenameFilter ymlFilter = (dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(YML);
        String path = this.dataObject.getSimpleName();
        StoreAt storeAt = this.dataObject.getAnnotation(StoreAt.class);
        if (storeAt != null) {
            path = storeAt.path();
        }
        if (!(tableFolder = new File(dataFolder = new File(this.plugin.getDataFolder(), "database"), path)).exists()) {
            tableFolder.mkdirs();
        }
        for (File file : Objects.requireNonNull(tableFolder.listFiles(ymlFilter))) {
            String fileName = file.getName();
            if (storeAt != null) {
                fileName = storeAt.filename();
            }
            YamlConfiguration config = ((YamlDatabaseConnector)this.databaseConnector).loadYamlFile("database" + File.separator + this.dataObject.getSimpleName(), fileName);
            list.add(this.createObject(config));
        }
        return list;
    }

    private T createObject(YamlConfiguration config) throws InstantiationException, IllegalAccessException, IntrospectionException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        Object instance = this.dataObject.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : this.dataObject.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), this.dataObject);
            Method method = propertyDescriptor.getWriteMethod();
            ConfigEntry configEntry = field.getAnnotation(ConfigEntry.class);
            String storageLocation = configEntry != null && !configEntry.path().isEmpty() ? configEntry.path() : field.getName();
            Adapter adapterNotation = field.getAnnotation(Adapter.class);
            if (adapterNotation != null && AdapterInterface.class.isAssignableFrom(adapterNotation.value())) {
                Object value = config.get(storageLocation);
                method.invoke(instance, ((AdapterInterface)adapterNotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).deserialize(value));
                continue;
            }
            if (!config.contains(storageLocation)) continue;
            if (config.get(storageLocation) == null) {
                method.invoke(instance, new Object[]{null});
                continue;
            }
            if (Map.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                this.deserializeMap(method, instance, storageLocation, config);
                continue;
            }
            if (Set.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                this.deserializeSet(method, instance, storageLocation, config);
                continue;
            }
            if (List.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                this.deserializeLists(method, instance, storageLocation, config);
                continue;
            }
            this.deserializeValue(method, instance, propertyDescriptor, storageLocation, config);
        }
        return instance;
    }

    private void deserializeValue(Method method, T instance, PropertyDescriptor propertyDescriptor, String storageLocation, YamlConfiguration config) throws IllegalAccessException, InvocationTargetException {
        block8: {
            Object value = config.get(storageLocation);
            if (value != null && !value.getClass().equals(MemorySection.class)) {
                Object setTo = this.deserialize(value, propertyDescriptor.getPropertyType());
                if (!Enum.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || setTo != null) {
                    try {
                        Type setType = propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0];
                        if (setType.getTypeName().equals("float")) {
                            double d = (Double)setTo;
                            float f = (float)d;
                            method.invoke(instance, Float.valueOf(f));
                            break block8;
                        }
                        if (setType.getTypeName().equals("org.bukkit.Sound")) {
                            Sound s = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)((String)setTo).toLowerCase(Locale.ENGLISH)));
                            method.invoke(instance, s);
                            break block8;
                        }
                        if (setType.getTypeName().equals("org.bukkit.block.Biome")) {
                            Biome b = (Biome)Registry.BIOME.get(NamespacedKey.fromString((String)((String)setTo).toLowerCase(Locale.ENGLISH)));
                            method.invoke(instance, b);
                            break block8;
                        }
                        method.invoke(instance, setTo);
                    }
                    catch (Exception e) {
                        this.plugin.logError("Could not deserialize. Attempt by " + instance.getClass().getCanonicalName() + " " + method.getName() + " to set to " + String.valueOf(setTo));
                        this.plugin.logError("Error message is: " + e.getMessage());
                        this.plugin.logStacktrace(e);
                    }
                } else {
                    this.plugin.logError("Default setting value will be used: " + String.valueOf(propertyDescriptor.getReadMethod().invoke(instance, new Object[0])));
                    this.plugin.logError(method.getName());
                    this.plugin.logError(propertyDescriptor.getReadMethod().getName());
                    this.plugin.logError(instance.toString());
                }
            }
        }
    }

    private void deserializeLists(Method method, T instance, String storageLocation, YamlConfiguration config) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        List<Type> collectionTypes = this.getCollectionParameterTypes(method);
        Type setType = collectionTypes.get(0);
        ArrayList<Object> value = new ArrayList<Object>();
        if (config.getList(storageLocation) != null) {
            for (Object listValue : config.getList(storageLocation)) {
                value.add(this.deserialize(listValue, Class.forName(setType.getTypeName())));
            }
        }
        method.invoke(instance, value);
    }

    private void deserializeSet(Method method, T instance, String storageLocation, YamlConfiguration config) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        List<Type> collectionTypes = this.getCollectionParameterTypes(method);
        Type setType = collectionTypes.get(0);
        HashSet<Object> value = new HashSet<Object>();
        if (config.getList(storageLocation) != null) {
            for (Object listValue : config.getList(storageLocation)) {
                value.add(this.deserialize(listValue, Class.forName(setType.getTypeName())));
            }
        }
        method.invoke(instance, value);
    }

    private void deserializeMap(Method method, T instance, String storageLocation, YamlConfiguration config) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        List<Type> collectionTypes = this.getCollectionParameterTypes(method);
        Type keyType = collectionTypes.get(0);
        Type valueType = collectionTypes.get(1);
        HashMap<Object, Object> value = new HashMap<Object, Object>();
        if (config.getConfigurationSection(storageLocation) != null) {
            for (String key : config.getConfigurationSection(storageLocation).getKeys(false)) {
                Object mapValue = this.deserialize(config.get(storageLocation + "." + key), Class.forName(valueType.getTypeName()));
                Object mapKey = this.deserialize(key = key.replace(":dot:", "."), Class.forName(keyType.getTypeName()));
                if (mapKey == null) continue;
                value.put(mapKey, mapValue);
            }
        }
        method.invoke(instance, value);
    }

    private List<Type> getCollectionParameterTypes(Method writeMethod) {
        Type[] genericParameterTypes;
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type genericParameterType : genericParameterTypes = writeMethod.getGenericParameterTypes()) {
            if (!(genericParameterType instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)genericParameterType;
            Type[] parameters = pt.getActualTypeArguments();
            result.addAll(Arrays.asList(parameters));
        }
        return result;
    }

    @Override
    public CompletableFuture<Boolean> saveObject(T instance) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (instance == null) {
            this.plugin.logError("YAML database request to store a null.");
            return CompletableFuture.completedFuture(false);
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            return CompletableFuture.completedFuture(false);
        }
        YamlConfiguration config = new YamlConfiguration();
        HashMap<String, String> yamlComments = new HashMap<String, String>();
        StoreAt storeAt = instance.getClass().getAnnotation(StoreAt.class);
        String path = storeAt == null ? "database" + File.separator + this.dataObject.getSimpleName() : storeAt.path();
        String filename = storeAt == null ? "" : storeAt.filename();
        this.handleComments(instance.getClass(), config, yamlComments, "");
        for (Field field : this.dataObject.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), this.dataObject);
            Method method = propertyDescriptor.getReadMethod();
            Object value = method.invoke(instance, new Object[0]);
            String storageLocation = field.getName();
            ConfigEntry configEntry = field.getAnnotation(ConfigEntry.class);
            if (configEntry != null && !configEntry.path().isEmpty()) {
                if (configEntry.hidden()) continue;
                storageLocation = configEntry.path();
                Object parent = "";
                if (storageLocation.contains(".")) {
                    parent = storageLocation.substring(0, storageLocation.lastIndexOf(46)) + ".";
                }
                this.handleComments(field, config, yamlComments, (String)parent);
                this.handleConfigEntryComments(configEntry, config, yamlComments, (String)parent);
            }
            if (this.checkAdapter(field, config, storageLocation, value)) continue;
            if (filename.isEmpty() && method.getName().equals("getUniqueId")) {
                filename = this.getFilename(propertyDescriptor, instance, (String)value);
            }
            if (Map.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && value != null) {
                this.serializeMap((Map)value, config, storageLocation);
                continue;
            }
            if (Set.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && value != null) {
                this.serializeSet((Set)value, config, storageLocation);
                continue;
            }
            config.set(storageLocation, this.serialize(value));
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException("No uniqueId in class");
        }
        this.save(completableFuture, filename, config.saveToString(), path, yamlComments);
        return completableFuture;
    }

    private void save(CompletableFuture<Boolean> completableFuture, String name, String data, String path, Map<String, String> yamlComments) {
        if (this.plugin.isEnabled()) {
            this.processQueue.add(() -> completableFuture.complete(((YamlDatabaseConnector)this.databaseConnector).saveYamlFile(data, path, name, yamlComments)));
        } else {
            completableFuture.complete(((YamlDatabaseConnector)this.databaseConnector).saveYamlFile(data, path, name, yamlComments));
        }
    }

    private void serializeSet(Set<Object> value, YamlConfiguration config, String storageLocation) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : value) {
            list.add(this.serialize(object));
        }
        config.set(storageLocation, list);
    }

    private void serializeMap(Map<Object, Object> value, YamlConfiguration config, String storageLocation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> object : value.entrySet()) {
            Object object2 = this.serialize(object.getKey());
            if (object2 instanceof String) {
                String key = (String)object2;
                key = key.replace("\\.", ":dot:");
                result.put(key, this.serialize(object.getValue()));
                continue;
            }
            this.plugin.logWarning("Map key in config file could not be serialized, skipping. Entry is " + String.valueOf(object.getKey()) + ": " + String.valueOf(object.getValue()));
        }
        config.set(storageLocation, result);
    }

    private String getFilename(PropertyDescriptor propertyDescriptor, T instance, String id) throws IllegalAccessException, InvocationTargetException {
        if (id == null || id.isEmpty()) {
            id = this.databaseConnector.getUniqueId(this.dataObject.getSimpleName());
            propertyDescriptor.getWriteMethod().invoke(instance, id);
        }
        return id;
    }

    private boolean checkAdapter(Field field, YamlConfiguration config, String storageLocation, Object value) throws IllegalAccessException, InvocationTargetException {
        Adapter adapterNotation = field.getAnnotation(Adapter.class);
        if (adapterNotation != null && AdapterInterface.class.isAssignableFrom(adapterNotation.value())) {
            try {
                config.set(storageLocation, ((AdapterInterface)adapterNotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).serialize(value));
            }
            catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                this.plugin.logError("Could not instantiate adapter " + adapterNotation.value().getName() + " " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    private void handleComments(@NonNull AnnotatedElement annotatedElement, @NonNull YamlConfiguration config, @NonNull Map<String, String> yamlComments, @NonNull String parent) {
        ConfigComment comment;
        ConfigComment.Line comments = annotatedElement.getAnnotation(ConfigComment.Line.class);
        if (comments != null) {
            for (ConfigComment comment2 : comments.value()) {
                this.setComment(comment2.value(), config, yamlComments, parent);
            }
        }
        if ((comment = annotatedElement.getAnnotation(ConfigComment.class)) != null) {
            this.setComment(comment.value(), config, yamlComments, parent);
        }
    }

    private void handleConfigEntryComments(@NonNull ConfigEntry configEntry, @NonNull YamlConfiguration config, @NonNull Map<String, String> yamlComments, @NonNull String parent) {
        if (!configEntry.video().isEmpty()) {
            this.setComment("You can find more details in this video: " + configEntry.video(), config, yamlComments, parent);
        }
        if (!configEntry.since().equals("1.0")) {
            this.setComment("Added since " + configEntry.since() + ".", config, yamlComments, parent);
        }
        if (configEntry.experimental()) {
            this.setComment("/!\\ This feature is experimental and might not work as expected or might not work at all.", config, yamlComments, parent);
        }
        if (configEntry.needsReset()) {
            this.setComment("/!\\ BentoBox currently does not support changing this value mid-game. If you do need to change it, do a full reset of your databases and worlds.", config, yamlComments, parent);
        }
        if (configEntry.needsRestart()) {
            this.setComment("/!\\ In order to apply the changes made to this option, you must restart your server. Reloading BentoBox or the server won't work.", config, yamlComments, parent);
        }
    }

    private void setComment(@NonNull String comment, @NonNull YamlConfiguration config, @NonNull Map<String, String> yamlComments, @NonNull String parent) {
        String random = "comment-" + String.valueOf(UUID.randomUUID());
        config.set(parent + random, (Object)" ");
        yamlComments.put(random, "# " + comment.replace("[version]", Objects.isNull(this.getAddon()) ? this.plugin.getDescription().getVersion() : this.getAddon().getDescription().getVersion()));
    }

    private @NonNull Object serialize(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof UUID) {
            return object.toString();
        }
        if (object instanceof World) {
            World w = (World)object;
            return w.getName();
        }
        if (object instanceof Location) {
            Location l = (Location)object;
            return Util.getStringLocation(l);
        }
        if (object instanceof Keyed) {
            Keyed k = (Keyed)object;
            return k.getKey().getKey();
        }
        if (object instanceof Enum) {
            Enum e = (Enum)object;
            return e.name();
        }
        return object;
    }

    private @Nullable Object deserialize(Object value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && value.equals("null")) {
            return null;
        }
        if (clazz.equals(value.getClass())) {
            return value;
        }
        if (clazz.equals(Long.class) && value.getClass().equals(Integer.class)) {
            return (long)((Integer)value).intValue();
        }
        if (value.getClass().equals(String.class)) {
            if (clazz.equals(Integer.class)) {
                return Integer.valueOf((String)value);
            }
            if (clazz.equals(Long.class)) {
                return Long.valueOf((String)value);
            }
            if (clazz.equals(Double.class)) {
                return Double.valueOf((String)value);
            }
            if (clazz.equals(Float.class)) {
                return Float.valueOf((String)value);
            }
        }
        if (clazz.equals(UUID.class)) {
            value = UUID.fromString((String)value);
        }
        if (clazz.equals(Location.class)) {
            value = Util.getLocationString((String)value);
        }
        if (clazz.equals(World.class)) {
            value = Bukkit.getWorld((String)((String)value));
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            Class<?> enumClass = clazz;
            try {
                String name = ((String)value).toUpperCase(Locale.ENGLISH);
                if (name.equals("PIG_ZOMBIE") || name.equals("ZOMBIFIED_PIGLIN")) {
                    return Enums.getIfPresent(EntityType.class, (String)"ZOMBIFIED_PIGLIN").or((Object)((EntityType)Enums.getIfPresent(EntityType.class, (String)"PIG_ZOMBIE").or((Object)EntityType.PIG)));
                }
                if (name.equals("GRASS") && Enums.getIfPresent(EntityType.class, (String)"SHORT_GRASS").isPresent()) {
                    return Enums.getIfPresent(EntityType.class, (String)"SHORT_GRASS");
                }
                value = Enum.valueOf(enumClass, name);
            }
            catch (Exception e) {
                this.plugin.logError("Error in YML file: " + String.valueOf(value) + " is not a valid value in the enum " + clazz.getCanonicalName() + "!");
                this.plugin.logError("Options are : ");
                for (Field fields : enumClass.getFields()) {
                    this.plugin.logError(fields.getName());
                }
                value = null;
            }
        }
        return value;
    }

    @Override
    public void deleteID(String uniqueId) {
        if (this.plugin.isEnabled()) {
            this.processQueue.add(() -> this.delete(uniqueId));
        } else {
            this.delete(uniqueId);
        }
    }

    private void delete(String uniqueId) {
        File dataFolder;
        File tableFolder;
        if (uniqueId == null) {
            return;
        }
        if (!((String)uniqueId).endsWith(YML)) {
            uniqueId = (String)uniqueId + YML;
        }
        if ((tableFolder = new File(dataFolder = new File(this.plugin.getDataFolder(), "database"), this.dataObject.getSimpleName())).exists()) {
            File file = new File(tableFolder, (String)uniqueId);
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                this.plugin.logError("Could not delete yml database object! " + file.getName() + " - " + e.getMessage());
            }
        }
    }

    @Override
    public void deleteObject(T instance) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (instance == null) {
            this.plugin.logError("YAML database request to delete a null.");
            return;
        }
        if (!(instance instanceof DataObject)) {
            this.plugin.logError("This class is not a DataObject: " + instance.getClass().getName());
            return;
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor("uniqueId", this.dataObject);
        Method method = propertyDescriptor.getReadMethod();
        this.deleteID((String)method.invoke(instance, new Object[0]));
    }

    @Override
    public void close() {
    }
}

