/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import com.meowj.langutils.lang.LanguageHelper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class LangUtilsHook
extends Hook {
    private static boolean hooked;

    public LangUtilsHook() {
        super("LangUtils", Material.BOOK);
    }

    private static boolean doHook(Plugin plugin) {
        if (plugin != null && plugin.isEnabled()) {
            String tag = plugin.getConfig().getString("Extra-TAG");
            if ("tag_r72EhIAL".equals(tag)) {
                hooked = true;
                return true;
            }
            Logger logger = BentoBox.getInstance().getLogger();
            logger.warning("This LangUtils version is not available for BentoBox.");
            logger.warning("Please go here to download the latest version:");
            logger.warning("https://github.com/apachezy/LangUtils/releases");
        }
        hooked = false;
        return false;
    }

    @Override
    public boolean hook() {
        return LangUtilsHook.doHook(this.getPlugin());
    }

    @Override
    public String getFailureCause() {
        return "The LangUtils version does not apply to BentoBox.";
    }

    public static boolean isHooked() {
        return hooked;
    }

    private static String getUserLocale(User user) {
        return user.getLocale().toLanguageTag();
    }

    public static String getItemDisplayName(ItemStack item, User user) {
        String dname;
        if (hooked) {
            return LanguageHelper.getItemDisplayName((ItemStack)item, (String)LangUtilsHook.getUserLocale(user));
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && !(dname = meta.getDisplayName()).isEmpty()) {
            return dname;
        }
        return Util.prettifyText(item.getType().name());
    }

    public static String getItemName(ItemStack itemStack, User user) {
        return hooked ? LanguageHelper.getItemName((ItemStack)itemStack, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(itemStack.getType().name());
    }

    public static String getMaterialName(Material material, User user) {
        return hooked ? LanguageHelper.getMaterialName((Material)material, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(material.name());
    }

    public static String getEntityDisplayName(Entity entity, User user) {
        return entity.getCustomName() != null ? entity.getCustomName() : LangUtilsHook.getEntityName(entity, user);
    }

    public static String getEntityName(EntityType entityType, User user) {
        return hooked ? LanguageHelper.getEntityName((EntityType)entityType, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(entityType.toString());
    }

    public static String getEntityName(Entity entity, User user) {
        return hooked ? LanguageHelper.getEntityName((Entity)entity, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(entity.getType().toString());
    }

    public static String getBiomeName(Biome biome, User user) {
        return hooked ? LanguageHelper.getBiomeName((Biome)biome, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(biome.name());
    }

    public static String getEnchantDisplayName(Enchantment ench, int level, User user) {
        return hooked ? LanguageHelper.getEnchantmentDisplayName((Enchantment)ench, (int)level, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(ench.getKey().getKey()) + " " + level;
    }

    public static String getEnchantDisplayName(Map.Entry<Enchantment, Integer> entry, User user) {
        return hooked ? LanguageHelper.getEnchantmentDisplayName(entry, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(entry.getKey().getKey().getKey()) + " " + String.valueOf(entry.getValue());
    }

    public static String getEnchantName(Enchantment enchant, User user) {
        return hooked ? LanguageHelper.getEnchantmentName((Enchantment)enchant, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(enchant.getKey().getKey());
    }

    public static String getEnchantLevelName(int level, User user) {
        return hooked ? LanguageHelper.getEnchantmentLevelName((int)level, (String)LangUtilsHook.getUserLocale(user)) : String.valueOf(level);
    }

    public static String getPotionTypeName(PotionType potionType, User user) {
        if (hooked) {
            return LanguageHelper.getPotionName((PotionType)potionType, (String)LangUtilsHook.getUserLocale(user));
        }
        return LangUtilsHook.generalPotionName(potionType);
    }

    private static String generalPotionName(PotionType potionType) {
        return switch (potionType) {
            case PotionType.WATER -> "Water Bottle";
            case PotionType.MUNDANE -> "Mundane Potion";
            case PotionType.THICK -> "Thick Potion";
            case PotionType.AWKWARD -> "Awkward Potion";
            case PotionType.NIGHT_VISION -> "Potion of Night Vision";
            case PotionType.INVISIBILITY -> "Potion of Invisibility";
            case PotionType.FIRE_RESISTANCE -> "Potion of Fire Resistance";
            case PotionType.SLOWNESS -> "Potion of Slowness";
            case PotionType.WATER_BREATHING -> "Potion of Water Breathing";
            case PotionType.POISON -> "Potion of Poison";
            case PotionType.STRENGTH -> "Potion of Strength";
            case PotionType.WEAKNESS -> "Potion of Weakness";
            case PotionType.LUCK -> "Potion of Luck";
            case PotionType.TURTLE_MASTER -> "Potion of the Turtle Master";
            case PotionType.SLOW_FALLING -> "Potion of Slow Falling";
            case PotionType.LONG_FIRE_RESISTANCE -> "Potion of Long Fire Resistance";
            case PotionType.LONG_INVISIBILITY -> "Potion of Long Invisibility";
            case PotionType.LONG_NIGHT_VISION -> "Potion of Long Night Vision";
            case PotionType.LONG_POISON -> "Potion of Long Poison";
            case PotionType.LONG_REGENERATION -> "Potion of Long Regeneration";
            case PotionType.LONG_SLOWNESS -> "Potion of Long Slowness";
            case PotionType.LONG_SLOW_FALLING -> "Potion of Long Slow Falling";
            case PotionType.LONG_STRENGTH -> "Potion of Long Strength";
            case PotionType.LONG_SWIFTNESS -> "Potion of Long Swiftness";
            case PotionType.LONG_TURTLE_MASTER -> "Potion of Long Turtle Master";
            case PotionType.LONG_WATER_BREATHING -> "Potion of Long Water Breathing";
            case PotionType.LONG_WEAKNESS -> "Potion of Long Weakness";
            case PotionType.STRONG_HARMING -> "Potion of Strong Harming";
            case PotionType.STRONG_HEALING -> "Potion of Strong Healing";
            case PotionType.STRONG_LEAPING -> "Potion of Strong Leaping";
            case PotionType.STRONG_POISON -> "Potion of Strong Poison";
            case PotionType.STRONG_REGENERATION -> "Potion of Strong Regeneration";
            case PotionType.STRONG_SLOWNESS -> "Potion of Strong Slowness";
            case PotionType.STRONG_STRENGTH -> "Potion of Strong Strength";
            case PotionType.STRONG_SWIFTNESS -> "Potion of Swiftness";
            case PotionType.STRONG_TURTLE_MASTER -> "Potion of Strong Turtle Master";
            default -> "Potion of " + Util.prettifyText(potionType.name());
        };
    }

    public static String getSplashPotionName(PotionType potionType, User user) {
        if (hooked) {
            return LanguageHelper.getSplashPotionName((PotionType)potionType, (String)LangUtilsHook.getUserLocale(user));
        }
        return "Splash" + LangUtilsHook.generalPotionName(potionType);
    }

    public static String getLingeringPotionName(PotionType potionType, User user) {
        if (hooked) {
            return LanguageHelper.getLingeringPotionName((PotionType)potionType, (String)LangUtilsHook.getUserLocale(user));
        }
        return "Lingering" + LangUtilsHook.generalPotionName(potionType);
    }

    public static String getTippedArrowName(PotionType potionType, User user) {
        if (hooked) {
            return LanguageHelper.getTippedArrowName((PotionType)potionType, (String)LangUtilsHook.getUserLocale(user));
        }
        return LangUtilsHook.generalPotionName(potionType).replaceAll("Potion", "Arrow");
    }

    public static String getPotionBaseEffectName(PotionType potionType, User user) {
        if (hooked) {
            return LanguageHelper.getPotionBaseEffectName((PotionType)potionType, (String)LangUtilsHook.getUserLocale(user));
        }
        try {
            List effects = potionType.getPotionEffects();
            if (effects.isEmpty()) {
                return "No Effects";
            }
            return effects.stream().map(effect -> Util.prettifyText(effect.getType().getKey().getKey())).collect(Collectors.joining(", "));
        }
        catch (Exception e) {
            return Util.prettifyText(potionType.getEffectType().getKey().getKey());
        }
    }

    public static String getPotionEffectName(PotionEffectType effectType, User user) {
        return hooked ? LanguageHelper.getPotionEffectName((PotionEffectType)effectType, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(effectType.getKey().getKey());
    }

    public static String getEffectAmplifierName(int amplifier, User user) {
        if (hooked) {
            return LanguageHelper.getEffectAmplifierName((int)amplifier, (String)LangUtilsHook.getUserLocale(user));
        }
        return amplifier > 0 ? Integer.toString(amplifier) : "";
    }

    public static String getPotionEffectDisplay(PotionEffect effect, User user) {
        int duration;
        if (hooked) {
            return LanguageHelper.getPotionEffectDisplay((PotionEffect)effect, (String)LangUtilsHook.getUserLocale(user));
        }
        Object effecName = LangUtilsHook.getPotionEffectName(effect.getType(), user);
        String amplifier = LangUtilsHook.getEffectAmplifierName(effect.getAmplifier(), user);
        if (amplifier.length() > 0) {
            effecName = (String)effecName + " " + amplifier;
        }
        if ((duration = effect.getDuration()) > 20) {
            int m = duration / 20 / 60;
            int s = duration / 20 % 60;
            String ts = String.format("%d:%02d", m, s);
            effecName = String.format("%s (%s)", effecName, ts);
        }
        return effecName;
    }

    public static String getTropicalFishTypeName(TropicalFish.Pattern fishPattern, User user) {
        return hooked ? LanguageHelper.getTropicalFishTypeName((TropicalFish.Pattern)fishPattern, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(fishPattern.name());
    }

    @Nullable
    public static String getPredefinedTropicalFishName(TropicalFishBucketMeta meta, User user) {
        if (hooked) {
            return LanguageHelper.getPredefinedTropicalFishName((TropicalFishBucketMeta)meta, (String)LangUtilsHook.getUserLocale(user));
        }
        if (meta.hasVariant()) {
            TropicalFish.Pattern pattern = meta.getPattern();
            int type = pattern.ordinal() > 5 ? 1 : 0;
            int patt = pattern.ordinal() % 6;
            int bcol = meta.getBodyColor().ordinal();
            int pcol = meta.getPatternColor().ordinal();
            int variant = (pcol & 0xFF) << 24 | (bcol & 0xFF) << 16 | (patt & 0xFF) << 8 | type;
            switch (variant) {
                case 0x7010101: {
                    return "Anemone";
                }
                case 0x7070001: {
                    return "Black Tang";
                }
                case 185008129: {
                    return "Blue Tang";
                }
                case 117441793: {
                    return "Butterflyfish";
                }
                case 118161664: {
                    return "Cichlid";
                }
                case 65536: {
                    return "Clownfish";
                }
                case 50726144: {
                    return "Cotton Candy Betta";
                }
                case 67764993: {
                    return "Dottyback";
                }
                case 234882305: {
                    return "Emperor Red Snapper";
                }
                case 0x4000500: {
                    return "Goatfish";
                }
                case 117441025: {
                    return "Moorish Idol";
                }
                case 0x1000501: {
                    return "Ornate Butterflyfish";
                }
                case 101253888: {
                    return "Parrotfish";
                }
                case 50660352: {
                    return "Queen Angelfish";
                }
                case 918529: {
                    return "Red Cichlid";
                }
                case 235340288: {
                    return "Red Lipped Blenny";
                }
                case 918273: {
                    return "Red Snapper";
                }
                case 0x4000001: {
                    return "Threadfin";
                }
                case 917504: {
                    return "Tomato Clownfish";
                }
                case 459008: {
                    return "Triggerfish";
                }
                case 67699456: {
                    return "Yellowtail Parrotfish";
                }
                case 0x4040001: {
                    return "Yellow Tang";
                }
            }
        }
        return null;
    }

    public static String getDyeColorName(DyeColor color, User user) {
        return hooked ? LanguageHelper.getDyeColorName((DyeColor)color, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(color.name());
    }

    public static String getVillagerLevelName(int level, User user) {
        return hooked ? LanguageHelper.getVillagerLevelName((int)level, (String)LangUtilsHook.getUserLocale(user)) : Integer.toString(level);
    }

    public static String getVillagerProfessionName(Villager.Profession profession, User user) {
        return hooked ? LanguageHelper.getVillagerProfessionName((Villager.Profession)profession, (String)LangUtilsHook.getUserLocale(user)) : Util.prettifyText(profession.name());
    }

    public static String getBannerPatternName(Pattern pattern, User user) {
        return hooked ? LanguageHelper.getBannerPatternName((Pattern)pattern, (String)LangUtilsHook.getUserLocale(user)) : pattern.getColor().name().toLowerCase(Locale.ROOT) + "_" + pattern.getPattern().name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static String getMusicDiskDesc(Material material, User user) {
        return switch (material) {
            case Material.MUSIC_DISC_13 -> "C418 - 13";
            case Material.MUSIC_DISC_CAT -> "C418 - cat";
            case Material.MUSIC_DISC_BLOCKS -> "C418 - blocks";
            case Material.MUSIC_DISC_CHIRP -> "C418 - chirp";
            case Material.MUSIC_DISC_FAR -> "C418 - far";
            case Material.MUSIC_DISC_MALL -> "C418 - mall";
            case Material.MUSIC_DISC_MELLOHI -> "C418 - mellohi";
            case Material.MUSIC_DISC_STAL -> "C418 - stal";
            case Material.MUSIC_DISC_STRAD -> "C418 - strad";
            case Material.MUSIC_DISC_WARD -> "C418 - ward";
            case Material.MUSIC_DISC_11 -> "C418 - 11";
            case Material.MUSIC_DISC_WAIT -> "C418 - wait";
            case Material.MUSIC_DISC_PIGSTEP -> "Lena Raine - Pigstep";
            case Material.MUSIC_DISC_5 -> "Samuel \u00c5berg - 5";
            case Material.MUSIC_DISC_OTHERSIDE -> "Lena Raine - otherside";
            default -> null;
        };
    }
}

