/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks.placeholders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.placeholders.PlaceholderReplacer;
import world.bentobox.bentobox.api.placeholders.placeholderapi.AddonPlaceholderExpansion;
import world.bentobox.bentobox.api.placeholders.placeholderapi.BentoBoxPlaceholderExpansion;
import world.bentobox.bentobox.hooks.placeholders.PlaceholderHook;

public class PlaceholderAPIHook
extends PlaceholderHook {
    private BentoBoxPlaceholderExpansion bentoboxExpansion;
    private final Map<Addon, AddonPlaceholderExpansion> addonsExpansions = new HashMap<Addon, AddonPlaceholderExpansion>();
    private final Set<String> bentoBoxPlaceholders = new HashSet<String>();
    private final Map<Addon, Set<String>> addonPlaceholders = new HashMap<Addon, Set<String>>();

    @Override
    public boolean hook() {
        try {
            this.bentoboxExpansion = new BentoBoxPlaceholderExpansion(BentoBox.getInstance());
        }
        catch (Exception | NoClassDefFoundError | NoSuchMethodError e) {
            return false;
        }
        return this.bentoboxExpansion.canRegister() && this.bentoboxExpansion.register();
    }

    @Override
    public String getFailureCause() {
        return "could not register BentoBox's expansion";
    }

    @Override
    public void registerPlaceholder(@NonNull String placeholder, @NonNull PlaceholderReplacer replacer) {
        this.bentoboxExpansion.registerPlaceholder(placeholder, replacer);
        this.bentoBoxPlaceholders.add(placeholder);
    }

    @Override
    public void registerPlaceholder(@NonNull Addon addon, @NonNull String placeholder, @NonNull PlaceholderReplacer replacer) {
        this.addonsExpansions.computeIfAbsent(addon, k -> {
            AddonPlaceholderExpansion addonPlaceholderExpansion = new AddonPlaceholderExpansion(addon);
            addonPlaceholderExpansion.register();
            this.addonPlaceholders.computeIfAbsent(addon, kk -> new HashSet()).add(placeholder);
            return addonPlaceholderExpansion;
        });
        this.addonsExpansions.get(addon).registerPlaceholder(placeholder, replacer);
    }

    @Override
    public void unregisterPlaceholder(@NonNull String placeholder) {
        this.bentoboxExpansion.unregisterPlaceholder(placeholder);
    }

    @Override
    public void unregisterPlaceholder(@NonNull Addon addon, @NonNull String placeholder) {
        if (this.addonsExpansions.containsKey(addon)) {
            this.addonsExpansions.get(addon).unregisterPlaceholder(placeholder);
        }
    }

    @Override
    public boolean isPlaceholder(@NonNull Addon addon, @NonNull String placeholder) {
        return this.addonsExpansions.containsKey(addon) && this.addonsExpansions.get(addon).isPlaceholder(placeholder);
    }

    @Override
    public @NonNull String replacePlaceholders(@Nullable Player player, @NonNull String string) {
        if (player == null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)this.removeGMPlaceholder(string));
        }
        String newString = BentoBox.getInstance().getIWM().getAddon(player.getWorld()).map(gm -> string.replace("[gamemode]", gm.getDescription().getName().toLowerCase())).orElseGet(() -> this.removeGMPlaceholder(string));
        return PlaceholderAPI.setPlaceholders((Player)player, (String)newString);
    }

    private String removeGMPlaceholder(@NonNull String string) {
        String newString = string;
        Matcher m = Pattern.compile("(%)(.*?)(%)").matcher(string);
        while (m.find()) {
            String ph = m.group();
            if (!ph.contains("[gamemode]")) continue;
            newString = newString.replace(ph, "");
        }
        return newString;
    }

    protected void setBentoboxExpansion(BentoBoxPlaceholderExpansion bentoboxExpansion) {
        this.bentoboxExpansion = bentoboxExpansion;
    }

    @Override
    public void unregisterAll() {
        this.bentoBoxPlaceholders.forEach(this::unregisterPlaceholder);
        this.addonPlaceholders.forEach((addon, list) -> list.forEach(placeholder -> this.unregisterPlaceholder((Addon)addon, (String)placeholder)));
    }
}

