/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.IslandsManager;

public class PrimaryIslandListener
implements Listener {
    private final IslandsManager im;

    public PrimaryIslandListener(@NonNull BentoBox plugin) {
        this.im = plugin.getIslands();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.setIsland(event.getPlayer(), event.getPlayer().getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getTo() != null && !event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
            this.setIsland(event.getPlayer(), event.getTo());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerTeleportEvent event) {
        if (event.getTo() != null) {
            this.setIsland(event.getPlayer(), event.getTo());
        }
    }

    private void setIsland(Player player, Location location) {
        this.im.getIslandAt(location).filter(i -> player.getUniqueId().equals(i.getOwner())).ifPresent(i -> this.im.setPrimaryIsland(player.getUniqueId(), (Island)i));
    }
}

