/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class ExplosionListener
extends FlagListener {
    private static final List<EntityType> TNT_TYPES = List.of(ExplosionListener.findFirstMatchingEnum(EntityType.class, "PRIMED_TNT", "TNT"), ExplosionListener.findFirstMatchingEnum(EntityType.class, "MINECART_TNT", "TNT_MINECART"));
    private static final List<Material> PRIMING_ITEMS = List.of(Material.FLINT_AND_STEEL, Material.FIRE_CHARGE);

    private static <T extends Enum<T>> T findFirstMatchingEnum(Class<T> enumClass, String ... values) {
        if (enumClass == null || values == null) {
            return null;
        }
        for (String value : values) {
            Optional enumConstant = Enums.getIfPresent(enumClass, (String)value.toUpperCase());
            if (!enumConstant.isPresent()) continue;
            return (T)((Enum)enumConstant.get());
        }
        return null;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTNTDamage(EntityChangeBlockEvent e) {
        Projectile projectile;
        if (!e.getBlock().getType().equals((Object)Material.TNT) || !this.getIWM().inWorld(e.getBlock().getLocation())) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            Player shooter = (Player)entity;
            if (projectile.getFireTicks() > 0 && !this.checkIsland((Event)e, shooter, e.getBlock().getLocation(), Flags.TNT_PRIMING)) {
                projectile.remove();
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTNTPriming(PlayerInteractEvent e) {
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && e.getClickedBlock() != null && e.getClickedBlock().getType().equals((Object)Material.TNT) && PRIMING_ITEMS.contains(e.getMaterial())) {
            this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.TNT_PRIMING);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        if (!this.getIWM().inWorld(e.getLocation()) || !TNT_TYPES.contains(e.getEntityType())) {
            return;
        }
        if (this.protect(e.getLocation())) {
            e.setCancelled(true);
        } else {
            e.blockList().removeIf(b -> this.protect(b.getLocation()));
        }
    }

    protected boolean protect(Location location) {
        return this.getIslands().getProtectedIslandAt(location).map(i -> !i.isAllowed(Flags.TNT_DAMAGE)).orElseGet(() -> !Flags.WORLD_TNT_DAMAGE.isSetForWorld(location.getWorld()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityDamageByEntityEvent e) {
        if (this.getIWM().inWorld(e.getEntity().getLocation()) && e.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) && TNT_TYPES.contains(e.getDamager().getType())) {
            e.setCancelled(this.protect(e.getEntity().getLocation()));
        }
    }

    protected boolean protectBlockExplode(Location location) {
        return this.getIslands().getProtectedIslandAt(location).map(i -> !i.isAllowed(Flags.BLOCK_EXPLODE_DAMAGE)).orElseGet(() -> !Flags.WORLD_BLOCK_EXPLODE_DAMAGE.isSetForWorld(location.getWorld()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(BlockExplodeEvent e) {
        if (!this.getIWM().inWorld(e.getBlock().getLocation())) {
            return;
        }
        if (this.protectBlockExplode(e.getBlock().getLocation())) {
            e.setCancelled(true);
        } else {
            e.blockList().removeIf(b -> this.protectBlockExplode(b.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onExplosion(EntityDamageEvent e) {
        if (this.getIWM().inWorld(e.getEntity().getLocation()) && e.getCause().equals((Object)EntityDamageEvent.DamageCause.BLOCK_EXPLOSION)) {
            e.setCancelled(this.protectBlockExplode(e.getEntity().getLocation()));
        }
    }
}

