/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.util.BlockIterator;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;

public class FireListener
extends FlagListener {
    public boolean checkFire(Cancellable e, Location l, Flag flag) {
        if (!this.getIWM().inWorld(l)) {
            return false;
        }
        boolean cancel = this.getIslands().getIslandAt(l).map(i -> !i.isAllowed(flag)).orElseGet(() -> !flag.isSetForWorld(l.getWorld()));
        e.setCancelled(cancel);
        return cancel;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent e) {
        this.checkFire((Cancellable)e, e.getBlock().getLocation(), Flags.FIRE_BURNING);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent e) {
        if (e.getSource().getType().equals((Object)Material.FIRE)) {
            this.checkFire((Cancellable)e, e.getBlock().getLocation(), Flags.FIRE_SPREAD);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent e) {
        if (!e.getBlock().getType().equals((Object)Material.OBSIDIAN)) {
            this.checkFire((Cancellable)e, e.getBlock().getLocation(), Flags.FIRE_IGNITE);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (e.getMaterial() == Material.FLINT_AND_STEEL || e.getMaterial() == Material.FIRE_CHARGE)) {
            this.checkIsland((Event)e, e.getPlayer(), e.getClickedBlock().getLocation(), Flags.FLINT_AND_STEEL);
        }
        try {
            BlockIterator iter = new BlockIterator((LivingEntity)e.getPlayer(), 10);
            while (iter.hasNext()) {
                Block lastBlock = iter.next();
                if (!lastBlock.getType().equals((Object)Material.FIRE)) continue;
                this.checkIsland((Event)e, e.getPlayer(), lastBlock.getLocation(), Flags.FIRE_EXTINGUISH);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLightningStrikeEvent(LightningStrikeEvent e) {
        this.checkFire((Cancellable)e, e.getLightning().getLocation(), Flags.FIRE_IGNITE);
    }
}

