/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Material;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class HurtingListener
extends FlagListener {
    private final Map<Integer, Player> thrownPotions = new HashMap<Integer, Player>();
    private final Map<Entity, Entity> firedFireworks = new WeakHashMap<Entity, Entity>();

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (Util.isTamableEntity(e.getEntity())) {
            this.respond(e, e.getDamager(), Flags.HURT_TAMED_ANIMALS);
        } else if (Util.isPassiveEntity(e.getEntity())) {
            this.respond(e, e.getDamager(), Flags.HURT_ANIMALS);
        } else if (e.getEntity() instanceof AbstractVillager) {
            this.respond(e, e.getDamager(), Flags.HURT_VILLAGERS);
        } else if (Util.isHostileEntity(e.getEntity())) {
            this.respond(e, e.getDamager(), Flags.HURT_MONSTERS);
        }
    }

    private void respond(EntityDamageByEntityEvent e, Entity damager, Flag flag) {
        Player player;
        Projectile p;
        ProjectileSource projectileSource;
        if (damager instanceof Player) {
            Player player2 = (Player)damager;
            this.checkIsland((Event)e, player2, e.getEntity().getLocation(), flag);
        } else if (damager instanceof Projectile && (projectileSource = (p = (Projectile)damager).getShooter()) instanceof Player && !this.checkIsland((Event)e, player = (Player)projectileSource, e.getEntity().getLocation(), flag)) {
            e.getEntity().setFireTicks(0);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFishing(PlayerFishEvent e) {
        if (e.getCaught() == null) {
            return;
        }
        if (Util.isTamableEntity(e.getCaught()) && this.checkIsland((Event)e, e.getPlayer(), e.getCaught().getLocation(), Flags.HURT_TAMED_ANIMALS) || Util.isPassiveEntity(e.getCaught()) && this.checkIsland((Event)e, e.getPlayer(), e.getCaught().getLocation(), Flags.HURT_ANIMALS) || Util.isHostileEntity(e.getCaught()) && this.checkIsland((Event)e, e.getPlayer(), e.getCaught().getLocation(), Flags.HURT_MONSTERS) || e.getCaught() instanceof AbstractVillager && this.checkIsland((Event)e, e.getPlayer(), e.getCaught().getLocation(), Flags.HURT_VILLAGERS)) {
            e.getHook().remove();
        }
        if (e.getCaught() instanceof ArmorStand && this.checkIsland((Event)e, e.getPlayer(), e.getCaught().getLocation(), Flags.ARMOR_STAND)) {
            e.getHook().remove();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerFeedParrots(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            if (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.COOKIE) || e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.COOKIE)) {
                if (parrot.isTamed()) {
                    this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.HURT_TAMED_ANIMALS);
                } else {
                    this.checkIsland((Event)e, e.getPlayer(), e.getRightClicked().getLocation(), Flags.HURT_ANIMALS);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSplashPotionSplash(PotionSplashEvent e) {
        ThrownPotion projectile = e.getEntity();
        ProjectileSource projectileSource = projectile.getShooter();
        if (projectileSource instanceof Player) {
            Player attacker = (Player)projectileSource;
            for (LivingEntity entity : e.getAffectedEntities()) {
                if (attacker.equals((Object)entity)) continue;
                if (Util.isHostileEntity((Entity)entity) && !this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_MONSTERS)) {
                    for (PotionEffect effect : e.getPotion().getEffects()) {
                        entity.removePotionEffect(effect.getType());
                    }
                }
                if (Util.isTamableEntity((Entity)entity) && !this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_TAMED_ANIMALS)) {
                    for (PotionEffect effect : e.getPotion().getEffects()) {
                        entity.removePotionEffect(effect.getType());
                    }
                }
                if (Util.isPassiveEntity((Entity)entity) && !this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_ANIMALS)) {
                    for (PotionEffect effect : e.getPotion().getEffects()) {
                        entity.removePotionEffect(effect.getType());
                    }
                }
                if (!(entity instanceof AbstractVillager) || this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_VILLAGERS)) continue;
                for (PotionEffect effect : e.getPotion().getEffects()) {
                    entity.removePotionEffect(effect.getType());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent e) {
        ThrownPotion projectile = e.getEntity();
        ProjectileSource projectileSource = projectile.getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            this.thrownPotions.put(e.getAreaEffectCloud().getEntityId(), player);
            this.getPlugin().getServer().getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> this.thrownPotions.remove(e.getAreaEffectCloud().getEntityId()), (long)e.getAreaEffectCloud().getDuration());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onLingeringPotionDamage(EntityDamageByEntityEvent e) {
        if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) && this.thrownPotions.containsKey(e.getDamager().getEntityId())) {
            Player attacker = this.thrownPotions.get(e.getDamager().getEntityId());
            this.processDamage(e, attacker);
        }
    }

    private void processDamage(EntityDamageByEntityEvent e, Player attacker) {
        if (attacker == null || attacker.equals((Object)e.getEntity())) {
            return;
        }
        Entity entity = e.getEntity();
        if (Util.isHostileEntity(entity)) {
            this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_MONSTERS);
        }
        if (Util.isTamableEntity(entity)) {
            this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_TAMED_ANIMALS);
        }
        if (Util.isPassiveEntity(entity)) {
            this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_ANIMALS);
        }
        if (entity instanceof AbstractVillager) {
            this.checkIsland((Event)e, attacker, entity.getLocation(), Flags.HURT_VILLAGERS);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFireworkDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Firework && this.firedFireworks.containsKey(e.getDamager())) {
            this.processDamage(e, (Player)this.firedFireworks.get(e.getDamager()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerShootEvent(EntityShootBowEvent e) {
        if (e.getEntityType().equals((Object)EntityType.PLAYER) && e.getProjectile() instanceof Firework) {
            this.firedFireworks.put(e.getProjectile(), (Entity)e.getEntity());
        }
    }
}

