/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.protection;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class LockAndBanListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        e.setCancelled(!this.checkAndNotify(e.getPlayer(), e.getTo()).equals((Object)CheckResult.OPEN));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        if (e.getFrom().getBlockX() - e.getTo().getBlockX() == 0 && e.getFrom().getBlockZ() - e.getTo().getBlockZ() == 0) {
            return;
        }
        if (!this.checkAndNotify(e.getPlayer(), e.getTo()).equals((Object)CheckResult.OPEN)) {
            e.setCancelled(true);
            e.getPlayer().playSound(e.getFrom(), Sound.BLOCK_ANVIL_HIT, 1.0f, 1.0f);
            e.getPlayer().setVelocity(new Vector(0, 0, 0));
            e.getPlayer().setGliding(false);
        }
        if (!this.check(e.getPlayer(), e.getFrom()).equals((Object)CheckResult.OPEN)) {
            Bukkit.getScheduler().runTask((Plugin)BentoBox.getInstance(), () -> this.eject(e.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVehicleMove(VehicleMoveEvent e) {
        if (e.getFrom().getBlockX() - e.getTo().getBlockX() == 0 && e.getFrom().getBlockZ() - e.getTo().getBlockZ() == 0) {
            return;
        }
        e.getVehicle().getPassengers().stream().filter(Player.class::isInstance).map(Player.class::cast).forEach(p -> {
            if (!this.checkAndNotify((Player)p, e.getTo()).equals((Object)CheckResult.OPEN)) {
                p.leaveVehicle();
                p.teleport(e.getFrom());
                e.getVehicle().getWorld().playSound(e.getFrom(), Sound.BLOCK_ANVIL_HIT, 1.0f, 1.0f);
                this.eject((Player)p);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerLogin(PlayerJoinEvent e) {
        if (!this.checkAndNotify(e.getPlayer(), e.getPlayer().getLocation()).equals((Object)CheckResult.OPEN)) {
            this.eject(e.getPlayer());
        }
    }

    private CheckResult check(@NonNull Player player, Location loc) {
        if (player.isOp() || player.hasMetadata("NPC")) {
            return CheckResult.OPEN;
        }
        return this.getIslands().getProtectedIslandAt(loc).map(is -> {
            if (is.isBanned(player.getUniqueId())) {
                return player.hasPermission(this.getIWM().getPermissionPrefix(loc.getWorld()) + "mod.bypassban") ? CheckResult.OPEN : CheckResult.BANNED;
            }
            if (!is.isAllowed(User.getInstance(player), Flags.LOCK)) {
                return player.hasPermission(this.getIWM().getPermissionPrefix(loc.getWorld()) + "mod.bypasslock") ? CheckResult.OPEN : CheckResult.LOCKED;
            }
            return CheckResult.OPEN;
        }).orElse(CheckResult.OPEN);
    }

    private CheckResult checkAndNotify(@NonNull Player player, Location loc) {
        CheckResult result = this.check(player, loc);
        if (result == CheckResult.BANNED) {
            User.getInstance(player).notify("commands.island.ban.you-are-banned", new String[0]);
        } else if (result == CheckResult.LOCKED) {
            User.getInstance(player).notify("protection.locked", new String[0]);
        }
        return result;
    }

    private void eject(Player player) {
        if (this.getIslands().hasIsland(player.getWorld(), player.getUniqueId()) || this.getIslands().inTeam(player.getWorld(), player.getUniqueId())) {
            this.getIslands().homeTeleportAsync(player.getWorld(), player);
        } else if (this.getIslands().getSpawn(player.getWorld()).isPresent()) {
            this.getIslands().spawnTeleport(player.getWorld(), player);
        } else {
            Location l = player.getWorld().getSpawnLocation();
            if (l != null) {
                Util.teleportAsync((Entity)player, l);
            }
            player.setGameMode(this.getIWM().getDefaultGameMode(player.getWorld()));
            this.getPlugin().logWarning("Could not teleport '" + player.getName() + "' back to his island or the spawn.");
            this.getPlugin().logWarning("Please consider setting a spawn for this world using the admin setspawn command.");
        }
    }

    private static enum CheckResult {
        BANNED,
        LOCKED,
        OPEN;

    }
}

