/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.LinkedList;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.nms.WorldRegenerator;
import world.bentobox.bentobox.util.Util;

public class CleanSuperFlatListener
extends FlagListener {
    private final BentoBox plugin = BentoBox.getInstance();
    private final @NonNull Queue<Chunk> chunkQueue = new LinkedList<Chunk>();
    private @Nullable BukkitTask task;
    private boolean ready;
    private WorldRegenerator regenerator;

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBentoBoxReady(BentoBoxReadyEvent e) {
        this.regenerator = Util.getRegenerator();
        if (this.regenerator == null) {
            this.plugin.logError("Could not start CleanSuperFlat because of NMS error");
            return;
        }
        this.ready = true;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent e) {
        World world = e.getWorld();
        if (this.noClean(world, e)) {
            return;
        }
        ChunkGenerator cg = this.plugin.getAddonsManager().getDefaultWorldGenerator(world.getName(), "");
        if (cg == null) {
            Flags.CLEAN_SUPER_FLAT.setSetting(world, false);
            this.plugin.logWarning("Could not enable Clean Super Flat for " + world.getName());
            this.plugin.logWarning("There is no world generator assigned to this world.");
            this.plugin.logWarning("This is often caused by the 'use-own-generator' being set to 'true' in the gamemode's configuration while there hasn't been any custom world generator assigned to the world.");
            this.plugin.logWarning("Either revert the changes in the gamemode's config.yml or assign your custom world generator to the world.");
            return;
        }
        this.chunkQueue.add(e.getChunk());
        if (this.task == null || this.task.isCancelled()) {
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.cleanChunk(world), 0L, 1L);
        }
    }

    private void cleanChunk(World world) {
        if (!this.chunkQueue.isEmpty()) {
            Chunk chunk = this.chunkQueue.poll();
            this.regenerator.regenerateChunk(chunk);
            if (this.plugin.getSettings().isLogCleanSuperFlatChunks()) {
                this.plugin.log("Regenerating superflat chunk in " + world.getName() + " at (" + chunk.getX() + ", " + chunk.getZ() + ") (" + this.chunkQueue.size() + " chunk(s) remaining in the queue)");
            }
        } else {
            this.task.cancel();
        }
    }

    private boolean noClean(World world, ChunkLoadEvent e) {
        if (!this.ready) {
            return true;
        }
        if (!(this.getIWM().inWorld(world) && Flags.CLEAN_SUPER_FLAT.isSetForWorld(world) && (!world.getEnvironment().equals((Object)World.Environment.NETHER) || this.plugin.getIWM().isNetherGenerate(world) && this.plugin.getIWM().isNetherIslands(world)) && (!world.getEnvironment().equals((Object)World.Environment.THE_END) || this.plugin.getIWM().isEndGenerate(world) && this.plugin.getIWM().isEndIslands(world)))) {
            return true;
        }
        int minHeight = world.getMinHeight();
        return !(e.getChunk().getBlock(0, 0, 0).getType().equals((Object)Material.BEDROCK) && e.getChunk().getBlock(0, 1, 0).getType().equals((Object)Material.DIRT) && e.getChunk().getBlock(0, 2, 0).getType().equals((Object)Material.DIRT) && e.getChunk().getBlock(0, 3, 0).getType().equals((Object)Material.GRASS_BLOCK) || e.getChunk().getBlock(0, minHeight, 0).getType().equals((Object)Material.BEDROCK) && e.getChunk().getBlock(0, minHeight + 1, 0).getType().equals((Object)Material.DIRT) && e.getChunk().getBlock(0, minHeight + 2, 0).getType().equals((Object)Material.DIRT) && e.getChunk().getBlock(0, minHeight + 3, 0).getType().equals((Object)Material.GRASS_BLOCK));
    }
}

