/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

public class EnterExitListener
extends FlagListener {
    private static final Vector XZ = new Vector(1, 0, 1);
    private static final String ISLAND_MESSAGE = "protection.flags.ENTER_EXIT_MESSAGES.island";

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        this.handleEnterExit(User.getInstance(e.getPlayer()), e.getFrom(), e.getTo(), e);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        this.handleEnterExit(User.getInstance(e.getPlayer()), e.getFrom(), e.getTo(), (PlayerMoveEvent)e);
    }

    private void handleEnterExit(@NonNull User user, @NonNull Location from, @Nullable Location to, @NonNull PlayerMoveEvent e) {
        Optional<Island> islandTo;
        if (from.getWorld() != null && to != null && from.getWorld().equals((Object)to.getWorld()) && from.toVector().multiply(XZ).equals((Object)to.toVector().multiply(XZ))) {
            return;
        }
        Optional<Island> islandFrom = this.getIslands().getProtectedIslandAt(from);
        Optional<Island> optional = islandTo = to == null ? Optional.empty() : this.getIslands().getProtectedIslandAt(to);
        if (islandFrom.equals(islandTo)) {
            return;
        }
        islandFrom.ifPresent(i -> {
            new IslandEvent.IslandEventBuilder().island((Island)i).oldIsland(islandTo.orElse(null)).involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.EXIT).admin(false).location(user.getLocation()).rawEvent((Event)e).build();
            this.sendExitNotification(user, (Island)i);
        });
        islandTo.ifPresent(i -> {
            new IslandEvent.IslandEventBuilder().island((Island)i).oldIsland(islandFrom.orElse(null)).involvedPlayer(user.getUniqueId()).reason(IslandEvent.Reason.ENTER).admin(false).location(user.getLocation()).rawEvent((Event)e).build();
            this.sendEnterNotification(user, (Island)i);
        });
    }

    private void sendExitNotification(@NonNull User user, @NonNull Island island) {
        if (!Flags.ENTER_EXIT_MESSAGES.isSetForWorld(island.getWorld())) {
            return;
        }
        if (island.isOwned()) {
            String islandMessage = user.getTranslation(island.getWorld(), ISLAND_MESSAGE, "[name]", this.getPlugin().getPlayers().getName(island.getOwner()));
            if (island.inTeam(user.getUniqueId())) {
                user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-leaving-your-island", "[name]", island.getName() != null ? island.getName() : islandMessage);
            } else {
                user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-leaving", "[name]", island.getName() != null ? island.getName() : islandMessage);
            }
        } else if (island.getName() != null) {
            user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-leaving", "[name]", island.getName());
        }
    }

    private void sendEnterNotification(@NonNull User user, @NonNull Island island) {
        if (!Flags.ENTER_EXIT_MESSAGES.isSetForWorld(island.getWorld())) {
            return;
        }
        if (island.isOwned()) {
            String islandMessage = user.getTranslation(island.getWorld(), ISLAND_MESSAGE, "[name]", this.getPlugin().getPlayers().getName(island.getOwner()));
            if (island.inTeam(user.getUniqueId())) {
                user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-entering-your-island", "[name]", island.getName() != null ? island.getName() : islandMessage);
            } else {
                user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-entering", "[name]", island.getName() != null ? island.getName() : islandMessage);
            }
        } else if (island.getName() != null) {
            user.notify(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.now-entering", "[name]", island.getName());
        }
    }
}

