/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFromToEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

public class LiquidsFlowingOutListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLiquidFlow(BlockFromToEvent e) {
        Block from = e.getBlock();
        Block to = e.getToBlock();
        if (!this.getIWM().inWorld(from.getLocation()) || Flags.LIQUIDS_FLOWING_OUT.isSetForWorld(from.getWorld())) {
            return;
        }
        if (to.getLocation().toVector().subtract(from.getLocation().toVector()).getY() != 0.0) {
            return;
        }
        Optional<Island> fromIsland = this.getIslands().getProtectedIslandAt(from.getLocation());
        Optional<Island> toIsland = this.getIslands().getProtectedIslandAt(to.getLocation());
        if (toIsland.isEmpty() || fromIsland.isPresent() && !fromIsland.equals(toIsland)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDispenserLiquid(BlockDispenseEvent event) {
        Location from = event.getBlock().getLocation();
        if (!this.getIWM().inWorld(from) || Flags.LIQUIDS_FLOWING_OUT.isSetForWorld(from.getWorld())) {
            return;
        }
        Location to = event.getVelocity().toLocation(event.getBlock().getWorld());
        if (!(event.getItem().getType().equals((Object)Material.WATER_BUCKET) || event.getItem().getType().equals((Object)Material.LAVA_BUCKET) || event.getItem().getType().equals((Object)Material.POWDER_SNOW_BUCKET))) {
            return;
        }
        Optional<Island> fromIsland = this.getIslandsManager().getProtectedIslandAt(from);
        Optional<Island> toIsland = this.getIslandsManager().getProtectedIslandAt(to);
        if (toIsland.isEmpty() || fromIsland.isPresent() && !fromIsland.equals(toIsland)) {
            event.setCancelled(true);
        }
    }
}

