/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.worldsettings;

import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

public class TreesGrowingOutsideRangeListener
extends FlagListener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onTreeGrow(StructureGrowEvent e) {
        if (!this.getIWM().inWorld(e.getWorld()) || Flags.TREES_GROWING_OUTSIDE_RANGE.isSetForWorld(e.getWorld())) {
            return;
        }
        Optional<Island> optionalProtectedIsland = this.getIslands().getProtectedIslandAt(e.getLocation());
        if (optionalProtectedIsland.isEmpty()) {
            e.setCancelled(true);
            return;
        }
        e.getBlocks().removeIf(blockState -> {
            Optional<Island> island = this.getIslands().getProtectedIslandAt(blockState.getLocation());
            return island.isEmpty() || !island.equals(optionalProtectedIsland);
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChorusGrow(BlockSpreadEvent e) {
        if (!this.getIWM().inWorld(e.getSource().getWorld()) || Flags.TREES_GROWING_OUTSIDE_RANGE.isSetForWorld(e.getSource().getWorld()) || !e.getSource().getType().equals((Object)Material.CHORUS_FLOWER)) {
            return;
        }
        Optional<Island> optionalProtectedIsland = this.getIslands().getProtectedIslandAt(e.getSource().getLocation());
        if (optionalProtectedIsland.isEmpty()) {
            e.setCancelled(true);
            return;
        }
        Optional<Island> island = this.getIslands().getProtectedIslandAt(e.getBlock().getLocation());
        if (island.isEmpty() || !island.equals(optionalProtectedIsland)) {
            e.setCancelled(true);
        }
    }
}

