/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.teleports;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public abstract class AbstractTeleportListener {
    protected final @NonNull BentoBox plugin;
    protected final Set<UUID> inPortal;
    protected final Map<UUID, World> teleportOrigin;
    protected final Set<UUID> inTeleport;

    AbstractTeleportListener(@NonNull BentoBox bentoBox) {
        this.plugin = bentoBox;
        this.inPortal = new HashSet<UUID>();
        this.inTeleport = new HashSet<UUID>();
        this.teleportOrigin = new HashMap<UUID, World>();
    }

    protected Optional<Island> getIsland(Location location) {
        return this.plugin.getIslandsManager().getProtectedIslandAt(location);
    }

    protected Optional<Island> getIsland(World world, Player player) {
        return Optional.ofNullable(this.plugin.getIslandsManager().getIsland(world, player.getUniqueId()));
    }

    protected boolean isMakePortals(World world, World.Environment environment) {
        return this.plugin.getIWM().getAddon(world).map(gameMode -> this.isMakePortals((GameModeAddon)gameMode, environment)).orElse(false);
    }

    protected boolean isMakePortals(GameModeAddon gameMode, World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> gameMode.getWorldSettings().isMakeNetherPortals();
            case World.Environment.THE_END -> gameMode.getWorldSettings().isMakeEndPortals();
            default -> false;
        };
    }

    protected boolean isAllowedInConfig(World overWorld, World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> this.plugin.getIWM().isNetherGenerate(overWorld);
            case World.Environment.THE_END -> this.plugin.getIWM().isEndGenerate(overWorld);
            default -> true;
        };
    }

    protected boolean isAllowedOnServer(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> Bukkit.getAllowNether();
            case World.Environment.THE_END -> Bukkit.getAllowEnd();
            default -> true;
        };
    }

    protected boolean isIslandWorld(World overWorld, World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> this.plugin.getIWM().isNetherIslands(overWorld);
            case World.Environment.THE_END -> this.plugin.getIWM().isEndIslands(overWorld);
            default -> true;
        };
    }

    protected World getNetherEndWorld(World overWorld, World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> this.plugin.getIWM().getNetherWorld(overWorld);
            case World.Environment.THE_END -> this.plugin.getIWM().getEndWorld(overWorld);
            default -> Util.getWorld(overWorld);
        };
    }

    protected boolean hasPartnerIsland(Island island, World.Environment environment) {
        return switch (environment) {
            case World.Environment.NETHER -> island.hasNetherIsland();
            case World.Environment.THE_END -> island.hasEndIsland();
            default -> true;
        };
    }

    protected int calculateSearchRadius(Location location, Island island) {
        int diff;
        if (island.onIsland(location)) {
            int x = Math.abs(island.getProtectionCenter().getBlockX() - location.getBlockX());
            int z = Math.abs(island.getProtectionCenter().getBlockZ() - location.getBlockZ());
            diff = Math.min(this.plugin.getSettings().getSafeSpotSearchRange(), island.getProtectionRange() - Math.max(x, z));
        } else {
            diff = this.plugin.getSettings().getSafeSpotSearchRange();
        }
        return diff;
    }

    protected Location calculateLocation(Location fromLocation, World fromWorld, World toWorld, World.Environment environment, boolean canCreatePortal) {
        if (fromWorld == null || toWorld == null) {
            return null;
        }
        Location toLocation = fromLocation.toVector().toLocation(toWorld);
        if (!this.isMakePortals(fromWorld, environment)) {
            toLocation = Objects.requireNonNullElse(this.getIsland(fromLocation).map(island -> island.getSpawnPoint(toWorld.getEnvironment())).orElse(toLocation), toLocation);
        }
        toLocation.setY(Math.max(Math.min(toLocation.getY(), (double)toWorld.getMaxHeight()), (double)toWorld.getMinHeight()));
        if (!canCreatePortal) {
            return toLocation;
        }
        if (!environment.equals((Object)World.Environment.THE_END)) {
            return toLocation;
        }
        int x = fromLocation.getBlockX();
        int z = fromLocation.getBlockZ();
        int y = fromLocation.getBlockY();
        int i = x;
        int j = z;
        int k = y;
        if (!fromLocation.getBlock().getType().equals((Object)Material.END_PORTAL)) {
            boolean continueSearch = true;
            for (int offsetX = 0; continueSearch && offsetX < 10; ++offsetX) {
                int posX = x + (offsetX % 2 == 0 ? 1 : -1) * (offsetX / 2);
                for (int offsetZ = 0; continueSearch && offsetZ < 10; ++offsetZ) {
                    int posZ = z + (offsetZ % 2 == 0 ? 1 : -1) * (offsetZ / 2);
                    for (int offsetY = 0; continueSearch && offsetY < 10; ++offsetY) {
                        int posY = y + (offsetY % 2 == 0 ? 1 : -1) * (offsetY / 2);
                        if (!fromWorld.getBlockAt(posX, posY, posZ).getType().equals((Object)Material.END_PORTAL)) continue;
                        i = posX;
                        j = posZ;
                        k = posY;
                        continueSearch = false;
                    }
                }
            }
        }
        Block portalBlock = fromWorld.getBlockAt(i, k, j);
        while (portalBlock.getRelative(1, 0, 0).getType() == Material.END_PORTAL) {
            portalBlock = portalBlock.getRelative(1, 0, 0);
            ++i;
        }
        while (portalBlock.getRelative(0, 0, 1).getType() == Material.END_PORTAL) {
            portalBlock = portalBlock.getRelative(0, 0, 1);
            ++j;
        }
        return new Location(toWorld, (double)i - 0.5, (double)Math.min(toWorld.getMaxHeight() - 2, Math.max(toWorld.getMinHeight() + 2, k)), (double)j - 0.5);
    }

    protected @Nullable Location getSpawnLocation(World world) {
        return this.plugin.getIslandsManager().getSpawn(world).map(island -> island.getSpawnPoint(World.Environment.NORMAL) == null ? island.getCenter() : island.getSpawnPoint(World.Environment.NORMAL)).orElse(this.plugin.getIslands().isSafeLocation(world.getSpawnLocation()) ? world.getSpawnLocation() : null);
    }

    protected boolean isPastingMissingIslands(World overWorld) {
        return this.plugin.getIWM().isPasteMissingIslands(overWorld) && !this.plugin.getIWM().isUseOwnGenerator(overWorld);
    }

    public Set<UUID> getInTeleport() {
        return this.inTeleport;
    }

    public Set<UUID> getInPortal() {
        return this.inPortal;
    }

    public Map<UUID, World> getTeleportOrigin() {
        return this.teleportOrigin;
    }
}

