/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.lists;

import java.text.DateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.placeholders.GameModePlaceholderReplacer;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public enum GameModePlaceholder {
    DEATHS("deaths", (addon, user, island) -> user == null ? "" : String.valueOf(addon.getPlayers().getDeaths(addon.getOverWorld(), user.getUniqueId()))),
    HAS_ISLAND("has_island", (addon, user, island) -> String.valueOf(user != null && island != null)),
    ISLAND_BANS_COUNT("island_bans_count", (addon, user, island) -> island == null ? "" : String.valueOf(island.getBanned().size())),
    ISLAND_CENTER("island_center", (addon, user, island) -> island == null ? "" : Util.xyz(island.getCenter().toVector())),
    ISLAND_CENTER_X("island_center_x", (addon, user, island) -> island == null ? "" : String.valueOf(island.getCenter().getBlockX())),
    ISLAND_CENTER_Y("island_center_y", (addon, user, island) -> island == null ? "" : String.valueOf(island.getCenter().getBlockY())),
    ISLAND_CENTER_Z("island_center_z", (addon, user, island) -> island == null ? "" : String.valueOf(island.getCenter().getBlockZ())),
    ISLAND_COOP_LIST("island_coop_list", (addon, user, island) -> island == null ? "" : island.getMemberSet(200, false).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))),
    ISLAND_COOPS_COUNT("island_coops_count", (addon, user, island) -> island == null ? "" : String.valueOf(island.getMemberSet(200, false).size())),
    ISLAND_CREATION_DATE("island_creation_date", (addon, user, island) -> island == null ? "" : DateFormat.getDateInstance(3).format(Date.from(Instant.ofEpochMilli(island.getCreatedDate())))),
    ISLAND_CREATION_TIME("island_creation_time", (addon, user, island) -> island == null ? "" : DateFormat.getTimeInstance(3).format(Date.from(Instant.ofEpochMilli(island.getCreatedDate())))),
    ISLAND_DISTANCE("island_distance", (addon, user, island) -> String.valueOf(addon.getWorldSettings().getIslandDistance())),
    ISLAND_DISTANCE_DIAMETER("island_distance_diameter", (addon, user, island) -> String.valueOf(2 * addon.getWorldSettings().getIslandDistance())),
    ISLAND_HISTORICAL_MEMBERS_COUNT("island_historical_members_count", (addon, user, island) -> island == null ? "" : GameModePlaceholder.getHistoricalMembers(island)),
    ISLAND_LOCATION("island_location", (addon, user, island) -> island == null ? "" : Util.xyz(island.getProtectionCenter().toVector())),
    ISLAND_LOCATION_X("island_location_x", (addon, user, island) -> island == null ? "" : String.valueOf(island.getProtectionCenter().getBlockX())),
    ISLAND_LOCATION_Y("island_location_y", (addon, user, island) -> island == null ? "" : String.valueOf(island.getProtectionCenter().getBlockY())),
    ISLAND_LOCATION_Z("island_location_z", (addon, user, island) -> island == null ? "" : String.valueOf(island.getProtectionCenter().getBlockZ())),
    ISLAND_MAX_HOMES("island_max_homes", (addon, user, island) -> island == null ? "" : String.valueOf(island.getMaxHomes() == null ? addon.getPlugin().getIWM().getMaxHomes(island.getWorld()) : island.getMaxHomes().intValue())),
    ISLAND_MEMBERS_COUNT("island_members_count", (addon, user, island) -> island == null ? "" : String.valueOf(island.getMemberSet().size())),
    ISLAND_MEMBERS_LIST("island_members_list", (addon, user, island) -> island == null ? "" : island.getMemberSet(500).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))),
    ISLAND_MEMBERS_MAX("island_members_max", (addon, user, island) -> island == null ? "" : String.valueOf(addon.getIslands().getMaxMembers(island, 500))),
    ISLAND_NAME("island_name", (addon, user, island) -> {
        if (island == null || user == null) {
            return "";
        }
        if (island.getName() == null) {
            return user.getTranslation(island.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.island", "[name]", addon.getPlayers().getName(island.getOwner()));
        }
        return island.getName();
    }),
    ISLAND_OWNER("island_owner", (addon, user, island) -> island == null ? "" : addon.getPlayers().getName(island.getOwner())),
    ISLAND_PROTECTION_RANGE("island_protection_range", (addon, user, island) -> island == null ? "" : String.valueOf(island.getProtectionRange())),
    ISLAND_PROTECTION_RANGE_DIAMETER("island_protection_range_diameter", (addon, user, island) -> island == null ? "" : String.valueOf(2 * island.getProtectionRange())),
    ISLAND_RANK("island_rank", (addon, user, island) -> island == null ? "" : user.getTranslationOrNothing(RanksManager.getInstance().getRank(island.getRank(user)), new String[0])),
    ISLAND_TRUSTED_LIST("island_trusted_list", (addon, user, island) -> island == null ? "" : island.getMemberSet(400, false).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))),
    ISLAND_TRUSTEES_COUNT("island_trustees_count", (addon, user, island) -> island == null ? "" : String.valueOf(island.getMemberSet(400, false).size())),
    ISLAND_UUID("island_uuid", (addon, user, island) -> island == null ? "" : island.getUniqueId()),
    ISLAND_VISITORS_COUNT("island_visitors_count", (addon, user, island) -> island == null ? "" : String.valueOf(island.getVisitors().size())),
    ON_ISLAND("on_island", (addon, user, island) -> String.valueOf(addon.getIslands().userIsOnIsland(addon.getOverWorld(), user) || addon.getIslands().userIsOnIsland(addon.getNetherWorld(), user) || addon.getIslands().userIsOnIsland(addon.getEndWorld(), user))),
    OWNS_ISLAND("owns_island", (addon, user, island) -> String.valueOf(island != null && user != null && user.getUniqueId().equals(island.getOwner()))),
    RANK("rank", (addon, user, island) -> island == null || user == null ? "" : user.getTranslation(RanksManager.getInstance().getRank(island.getRank(user)), new String[0])),
    RESETS("resets", (addon, user, island) -> user == null ? "" : String.valueOf(addon.getPlayers().getResets(addon.getOverWorld(), user.getUniqueId()))),
    RESETS_LEFT("resets_left", (addon, user, island) -> user == null ? "" : String.valueOf(addon.getPlayers().getResetsLeft(addon.getOverWorld(), user.getUniqueId()))),
    VISITED_ISLAND_BANS_COUNT("visited_island_bans_count", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getBanned().size())).orElse("")),
    VISITED_ISLAND_CENTER("visited_island_center", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> Util.xyz(value.getCenter().toVector())).orElse("")),
    VISITED_ISLAND_CENTER_X("visited_island_center_x", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getCenter().getBlockX())).orElse("")),
    VISITED_ISLAND_CENTER_Y("visited_island_center_y", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getCenter().getBlockY())).orElse("")),
    VISITED_ISLAND_CENTER_Z("visited_island_center_z", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getCenter().getBlockZ())).orElse("")),
    VISITED_ISLAND_COOP_LIST("visited_island_coop_list", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> value.getMemberSet(200, false).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))).orElse("")),
    VISITED_ISLAND_COOPS_COUNT("visited_island_coops_count", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getMemberSet(200, false).size())).orElse("")),
    VISITED_ISLAND_CREATION_DATE("visited_island_creation_date", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> DateFormat.getInstance().format(Date.from(Instant.ofEpochMilli(value.getCreatedDate())))).orElse("")),
    VISITED_ISLAND_LOCATION("visited_island_location", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> Util.xyz(value.getProtectionCenter().toVector())).orElse("")),
    VISITED_ISLAND_LOCATION_X("visited_island_location_x", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getProtectionCenter().getBlockX())).orElse("")),
    VISITED_ISLAND_LOCATION_Y("visited_island_location_y", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getProtectionCenter().getBlockY())).orElse("")),
    VISITED_ISLAND_LOCATION_Z("visited_island_location_z", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getProtectionCenter().getBlockZ())).orElse("")),
    VISITED_ISLAND_MAX_HOMES("visited_island_max_homes", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(island.getMaxHomes() == null ? addon.getPlugin().getIWM().getMaxHomes(island.getWorld()) : island.getMaxHomes().intValue())).orElse("")),
    VISITED_ISLAND_MEMBERS_COUNT("visited_island_members_count", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getMemberSet().size())).orElse("")),
    VISITED_ISLAND_MEMBERS_LIST("visited_island_members_list", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> value.getMemberSet(500).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))).orElse("")),
    VISITED_ISLAND_MEMBERS_MAX("visited_island_members_max", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(addon.getIslands().getMaxMembers((Island)value, 500))).orElse("")),
    VISITED_ISLAND_NAME("visited_island_name", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(is -> {
        if (is.getName() != null) {
            return is.getName();
        }
        return user.getTranslation(is.getWorld(), "protection.flags.ENTER_EXIT_MESSAGES.island", "[name]", addon.getPlayers().getName(is.getOwner()));
    }).orElse("")),
    VISITED_ISLAND_OWNER("visited_island_owner", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> addon.getPlayers().getName(value.getOwner())).orElse("")),
    VISITED_ISLAND_PROTECTION_RANGE("visited_island_protection_range", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getProtectionRange())).orElse("")),
    VISITED_ISLAND_PROTECTION_RANGE_DIAMETER("visited_island_protection_range_diameter", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(2 * value.getProtectionRange())).orElse("")),
    VISITED_ISLAND_RANK("visited_island_rank", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(is -> user.getTranslation(RanksManager.getInstance().getRank(is.getRank(user)), new String[0])).orElse("")),
    VISITED_ISLAND_TRUSTED_LIST("visited_island_trusted_list", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> value.getMemberSet(400, false).stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))).orElse("")),
    VISITED_ISLAND_TRUSTEES_COUNT("visited_island_trustees_count", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getMemberSet(400, false).size())).orElse("")),
    VISITED_ISLAND_UUID("visited_island_uuid", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(Island::getUniqueId).orElse("")),
    VISITED_ISLAND_VISITORS_COUNT("visited_island_visitors_count", (addon, user, island) -> GameModePlaceholder.getVisitedIsland(addon, user).map(value -> String.valueOf(value.getVisitors().size())).orElse("")),
    WORLD_FRIENDLY_NAME("world_friendly_name", (addon, user, island) -> addon.getWorldSettings().getFriendlyName()),
    WORLD_ISLANDS("world_islands", (addon, user, island) -> String.valueOf(addon.getIslands().getIslandCount(addon.getOverWorld())));

    private final String placeholder;
    private final GameModePlaceholderReplacer replacer;

    private static String getHistoricalMembers(@Nullable Island island) {
        HashSet<String> uniqueMembers = new HashSet<String>();
        for (LogEntry le : island.getHistory()) {
            if (le.getType() != LogEntry.LogType.JOINED) continue;
            Iterator<String> it = le.getData().keySet().iterator();
            while (it.hasNext()) {
                uniqueMembers.add(it.next());
            }
        }
        return String.valueOf(uniqueMembers.size());
    }

    private static Optional<Island> getVisitedIsland(@NonNull GameModeAddon addon, @Nullable User user) {
        if (user == null || !user.isPlayer() || user.getLocation() == null) {
            return Optional.empty();
        }
        return addon.getIslands().getIslandAt(user.getLocation());
    }

    private GameModePlaceholder(String placeholder, GameModePlaceholderReplacer replacer) {
        this.placeholder = placeholder;
        this.replacer = replacer;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public GameModePlaceholderReplacer getReplacer() {
        return this.replacer;
    }
}

