/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.database.json.BentoboxTypeAdapterFactory;

public class BlueprintClipboardManager {
    private static final String LOAD_ERROR = "Could not load blueprint file - does not exist : ";
    private final File blueprintFolder;
    private BlueprintClipboard clipboard;
    private Gson gson;
    private final BentoBox plugin;

    public BlueprintClipboardManager(BentoBox plugin, File blueprintFolder) {
        this(plugin, blueprintFolder, null);
    }

    public BlueprintClipboardManager(BentoBox plugin, File blueprintFolder, BlueprintClipboard clipboard) {
        this.plugin = plugin;
        if (!blueprintFolder.exists()) {
            blueprintFolder.mkdirs();
        }
        this.blueprintFolder = blueprintFolder;
        this.clipboard = clipboard;
        this.getGson();
    }

    public BlueprintClipboard getClipboard() {
        return this.clipboard;
    }

    private void getGson() {
        GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization();
        builder.disableHtmlEscaping();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new BentoboxTypeAdapterFactory(this.plugin));
        this.gson = builder.create();
    }

    public void load(String fileName) throws IOException {
        this.clipboard = new BlueprintClipboard(this.loadBlueprint(fileName));
    }

    public Blueprint loadBlueprint(String fileName) throws IOException {
        Blueprint bp;
        File zipFile = new File(this.blueprintFolder, fileName + ".blu");
        if (!zipFile.exists()) {
            this.plugin.logError(LOAD_ERROR + zipFile.getName());
            throw new IOException(LOAD_ERROR + zipFile.getName());
        }
        this.unzip(zipFile.getCanonicalPath());
        File file = new File(this.blueprintFolder, fileName);
        if (!file.exists()) {
            this.plugin.logError(LOAD_ERROR + file.getName());
            throw new IOException(LOAD_ERROR + file.getName() + " temp file");
        }
        try (FileReader fr = new FileReader(file, StandardCharsets.UTF_8);){
            bp = (Blueprint)this.gson.fromJson((Reader)fr, Blueprint.class);
        }
        catch (Exception e) {
            this.plugin.logError("Blueprint has JSON error: " + zipFile.getName());
            this.plugin.logStacktrace(e);
            throw new IOException("Blueprint has JSON error: " + zipFile.getName());
        }
        Files.delete(file.toPath());
        if (bp.getBedrock() == null) {
            bp.setBedrock(new Vector(bp.getxSize() / 2, bp.getySize() / 2, bp.getzSize() / 2));
            bp.getBlocks().put(bp.getBedrock(), new BlueprintBlock(Material.BEDROCK.createBlockData().getAsString()));
            this.plugin.logWarning("Blueprint " + fileName + ".blu had no bedrock block in it so one was added automatically in the center. You should check it.");
        }
        return bp;
    }

    public boolean load(User user, String fileName) {
        try {
            this.load(fileName);
        }
        catch (IOException e1) {
            user.sendMessage("commands.admin.blueprint.could-not-load", new String[0]);
            this.plugin.logError("Could not load blueprint file: " + fileName + ".blu " + e1.getMessage());
            return false;
        }
        user.sendMessage("general.success", new String[0]);
        return true;
    }

    public boolean save(User user, String newName, String displayName) {
        if (this.clipboard.isFull()) {
            this.clipboard.getBlueprint().setName(newName);
            this.clipboard.getBlueprint().setDisplayName(displayName);
            if (this.saveBlueprint(this.clipboard.getBlueprint())) {
                user.sendMessage("general.success", new String[0]);
                return true;
            }
        }
        user.sendMessage("commands.admin.blueprint.could-not-save", "[message]", "Could not save temp blueprint file.");
        return false;
    }

    public boolean saveBlueprint(Blueprint blueprint) {
        if (blueprint.getName().isEmpty()) {
            this.plugin.logError("Blueprint name was empty - could not save it");
            return false;
        }
        File file = new File(this.blueprintFolder, blueprint.getName());
        String toStore = this.gson.toJson((Object)blueprint, Blueprint.class);
        try (FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);){
            fileWriter.write(toStore);
        }
        catch (IOException e) {
            this.plugin.logError("Could not save temporary blueprint file: " + file.getName());
            return false;
        }
        try {
            this.zip(file);
        }
        catch (IOException e) {
            this.plugin.logError("Could not zip temporary blueprint file: " + file.getName());
            return false;
        }
        return true;
    }

    private void unzip(String zipFilePath) throws IOException {
        Path path = Paths.get(zipFilePath, new String[0]);
        if (!path.toFile().exists()) {
            throw new IOException("No file exists!");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                Path filePath = Paths.get(path.getParent().toString(), entry.getName());
                if (!entry.isDirectory()) {
                    this.unzipFiles(zipInputStream, filePath);
                } else {
                    if (!filePath.startsWith(this.blueprintFolder.getCanonicalPath())) {
                        throw new IOException("Entry is outside of the target directory");
                    }
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private void unzipFiles(ZipInputStream zipInputStream, Path unzipFilePath) throws IOException {
        if (!unzipFilePath.startsWith(this.blueprintFolder.getCanonicalFile().toPath().normalize())) {
            throw new IOException("Blueprint file is trying to write outside of the target directory! Blocked attempt to write to " + unzipFilePath.toString());
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(unzipFilePath.toFile().getCanonicalPath()));){
            int read;
            byte[] bytesIn = new byte[1024];
            while ((read = zipInputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private void zip(File targetFile) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(targetFile.getCanonicalPath() + ".blu"));){
            zipOutputStream.putNextEntry(new ZipEntry(targetFile.getName()));
            try (FileInputStream inputStream = new FileInputStream(targetFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) >= 0) {
                    zipOutputStream.write(buffer, 0, length);
                }
            }
            try {
                Files.delete(targetFile.toPath());
            }
            catch (Exception e) {
                this.plugin.logError(e.getMessage());
            }
        }
    }
}

