/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.BlueprintPaster;
import world.bentobox.bentobox.blueprints.DisplayListener;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.database.json.BentoboxTypeAdapterFactory;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.BlueprintClipboardManager;
import world.bentobox.bentobox.util.Util;

public class BlueprintsManager {
    private static final String BLUEPRINT_BUNDLE_SUFFIX = ".json";
    public static final String BLUEPRINT_SUFFIX = ".blu";
    public static final String DEFAULT_BUNDLE_NAME = "default";
    public static final @NonNull String FOLDER_NAME = "blueprints";
    private static final String FOR = "' for ";
    private final @NonNull Map<GameModeAddon, List<BlueprintBundle>> blueprintBundles;
    private final @NonNull Map<GameModeAddon, List<Blueprint>> blueprints;
    private final Gson gson;
    private final @NonNull BentoBox plugin;
    private final @NonNull Set<GameModeAddon> blueprintsLoaded;

    public BlueprintsManager(@NonNull BentoBox plugin) {
        this.plugin = plugin;
        this.blueprintBundles = new ConcurrentHashMap<GameModeAddon, List<BlueprintBundle>>();
        this.blueprints = new ConcurrentHashMap<GameModeAddon, List<Blueprint>>();
        GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(EnumMap.class, type -> {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            return new EnumMap((Class)types[0]);
        });
        builder.disableHtmlEscaping();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new BentoboxTypeAdapterFactory(plugin));
        this.gson = builder.create();
        this.blueprintsLoaded = new HashSet<GameModeAddon>();
        Bukkit.getPluginManager().registerEvents((Listener)new DisplayListener(), (Plugin)plugin);
    }

    public void extractDefaultBlueprints(@NonNull GameModeAddon addon) {
        File folder = this.getBlueprintsFolder(addon);
        if (folder.exists()) {
            return;
        }
        if (!folder.exists() && !folder.mkdirs()) {
            this.plugin.logError("Could not create the 'blueprints' folder!");
            this.plugin.logError("This might be due to incorrectly set-up write permissions on the operating system.");
            return;
        }
        try (JarFile jar = new JarFile(addon.getFile());){
            Util.listJarFiles(jar, FOLDER_NAME, BLUEPRINT_BUNDLE_SUFFIX).forEach(name -> addon.saveResource((String)name, false));
            Util.listJarFiles(jar, FOLDER_NAME, BLUEPRINT_SUFFIX).forEach(name -> addon.saveResource((String)name, false));
        }
        catch (IOException e) {
            this.plugin.logError("Could not load blueprint files from addon jar " + e.getMessage());
        }
    }

    public @NonNull Map<String, BlueprintBundle> getBlueprintBundles(@NonNull GameModeAddon addon) {
        if (!this.blueprintBundles.containsKey(addon)) {
            return new HashMap<String, BlueprintBundle>();
        }
        return this.blueprintBundles.get(addon).stream().collect(Collectors.toMap(BlueprintBundle::getUniqueId, b -> b));
    }

    public @Nullable BlueprintBundle getDefaultBlueprintBundle(@NonNull GameModeAddon addon) {
        if (this.blueprintBundles.containsKey(addon)) {
            return this.blueprintBundles.get(addon).stream().filter(bb -> bb.getUniqueId().equals(DEFAULT_BUNDLE_NAME)).findFirst().orElse(null);
        }
        return null;
    }

    private @NonNull File getBlueprintsFolder(@NonNull GameModeAddon addon) {
        return new File(addon.getDataFolder(), FOLDER_NAME);
    }

    public void loadBlueprintBundles(@NonNull GameModeAddon addon) {
        this.blueprintsLoaded.add(addon);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.blueprintBundles.put(addon, new ArrayList());
            if (!this.loadBundles(addon)) {
                this.makeDefaults(addon);
                this.loadBundles(addon);
            }
            this.loadBlueprints(addon);
            this.blueprintsLoaded.remove(addon);
        });
    }

    public boolean isBlueprintsLoaded() {
        return this.blueprintsLoaded.isEmpty();
    }

    private boolean loadBundles(@NonNull GameModeAddon addon) {
        File bpf = this.getBlueprintsFolder(addon);
        if (!bpf.exists()) {
            this.plugin.logError("There is no blueprint folder for addon " + addon.getDescription().getName());
            bpf.mkdirs();
        }
        boolean loaded = false;
        File[] bundles = bpf.listFiles((dir, name) -> name.endsWith(BLUEPRINT_BUNDLE_SUFFIX));
        if (bundles == null || bundles.length == 0) {
            return false;
        }
        for (File file : bundles) {
            try (FileReader fileReader = new FileReader(file, StandardCharsets.UTF_8);){
                if (!file.getName().equals(Util.sanitizeInput(file.getName()))) {
                    throw new InputMismatchException(file.getName());
                }
                BlueprintBundle bb = (BlueprintBundle)this.gson.fromJson((Reader)fileReader, BlueprintBundle.class);
                if (bb == null) continue;
                if (this.blueprintBundles.get(addon).stream().noneMatch(bundle -> bundle.getUniqueId().equals(bb.getUniqueId()))) {
                    this.blueprintBundles.get(addon).add(bb);
                    this.plugin.log("Loaded Blueprint Bundle '" + bb.getUniqueId() + FOR + addon.getDescription().getName() + ".");
                    loaded = true;
                    continue;
                }
                this.plugin.logWarning("Could not load blueprint bundle '" + file.getName() + FOR + addon.getDescription().getName() + ".");
                this.plugin.logWarning("The uniqueId '" + bb.getUniqueId() + "' is already used by another Blueprint Bundle.");
                this.plugin.logWarning("This can occur if the Blueprint Bundles' files were manually edited.");
                this.plugin.logWarning("Please review your Blueprint Bundles' files and make sure their uniqueIds are not in duplicate.");
            }
            catch (Exception e) {
                this.plugin.logError("Could not load blueprint bundle '" + file.getName() + "'. Cause: " + e.getMessage() + ".");
                this.plugin.logStacktrace(e);
            }
        }
        return loaded;
    }

    private BlueprintBundle getDefaultBlueprintBundle() {
        BlueprintBundle bb = new BlueprintBundle();
        bb.setIcon(Material.PAPER);
        bb.setUniqueId(DEFAULT_BUNDLE_NAME);
        bb.setDisplayName("Default bundle");
        bb.setDescription(Collections.singletonList(String.valueOf(NamedTextColor.AQUA) + "Default bundle of blueprints"));
        return bb;
    }

    private Blueprint getDefaultBlueprint() {
        Blueprint defaultBp = new Blueprint();
        defaultBp.setName("bedrock");
        defaultBp.setDescription(Collections.singletonList(String.valueOf(NamedTextColor.AQUA) + "A bedrock block"));
        defaultBp.setBedrock(new Vector(0, 0, 0));
        HashMap<Vector, BlueprintBlock> map = new HashMap<Vector, BlueprintBlock>();
        map.put(new Vector(0, 0, 0), new BlueprintBlock("minecraft:bedrock"));
        defaultBp.setBlocks(map);
        return defaultBp;
    }

    private void makeDefaults(@NonNull GameModeAddon addon) {
        this.plugin.logError("No blueprint bundles found! Creating a default one.");
        BlueprintBundle bb = this.getDefaultBlueprintBundle();
        Blueprint defaultBp = this.getDefaultBlueprint();
        new BlueprintClipboardManager(this.plugin, this.getBlueprintsFolder(addon)).saveBlueprint(defaultBp);
        bb.setBlueprint(World.Environment.NORMAL, defaultBp);
        bb.setBlueprint(World.Environment.NETHER, defaultBp);
        bb.setBlueprint(World.Environment.THE_END, defaultBp);
        bb.setUniqueId(DEFAULT_BUNDLE_NAME);
        this.blueprintBundles.get(addon).add(bb);
        this.saveBlueprintBundles();
    }

    public void loadBlueprints(@NonNull GameModeAddon addon) {
        File[] bps;
        this.blueprints.put(addon, new ArrayList());
        File bpf = this.getBlueprintsFolder(addon);
        if (!bpf.exists()) {
            this.plugin.logError("There is no blueprint folder for addon " + addon.getDescription().getName());
            bpf.mkdirs();
        }
        if ((bps = bpf.listFiles((dir, name) -> name.endsWith(BLUEPRINT_SUFFIX))) == null || bps.length == 0) {
            this.plugin.logError("No blueprints found for " + addon.getDescription().getName());
            return;
        }
        for (File file : bps) {
            String fileName = Util.sanitizeInput(file.getName().substring(0, file.getName().length() - BLUEPRINT_SUFFIX.length()));
            try {
                Blueprint bp = new BlueprintClipboardManager(this.plugin, bpf).loadBlueprint(fileName);
                bp.setName(fileName);
                this.blueprints.get(addon).add(bp);
                this.plugin.log("Loaded blueprint '" + bp.getName() + FOR + addon.getDescription().getName());
            }
            catch (Exception e) {
                this.plugin.logError("Could not load blueprint " + fileName + " " + e.getMessage());
                this.plugin.logStacktrace(e);
            }
        }
    }

    public void addBlueprint(@NonNull GameModeAddon addon, @NonNull Blueprint bp) {
        this.blueprints.putIfAbsent(addon, new ArrayList());
        this.blueprints.get(addon).removeIf(b -> b.getName().equals(bp.getName()));
        this.blueprints.get(addon).add(bp);
        this.plugin.log("Added blueprint '" + bp.getName() + FOR + addon.getDescription().getName());
    }

    public boolean saveBlueprint(@NonNull GameModeAddon addon, @NonNull Blueprint bp) {
        return new BlueprintClipboardManager(this.plugin, this.getBlueprintsFolder(addon)).saveBlueprint(bp);
    }

    public void saveBlueprintBundle(GameModeAddon addon, BlueprintBundle bb) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            File bpf = this.getBlueprintsFolder(addon);
            if (!bpf.exists()) {
                bpf.mkdirs();
            }
            File fileName = new File(bpf, bb.getUniqueId() + BLUEPRINT_BUNDLE_SUFFIX);
            String toStore = this.gson.toJson((Object)bb, BlueprintBundle.class);
            try (FileWriter fileWriter = new FileWriter(fileName, StandardCharsets.UTF_8);){
                fileWriter.write(toStore);
            }
            catch (IOException e) {
                this.plugin.logError("Could not save blueprint bundle file: " + e.getMessage());
            }
        });
    }

    public void saveBlueprintBundles() {
        this.blueprintBundles.forEach((k, v) -> v.forEach(m -> this.saveBlueprintBundle((GameModeAddon)k, (BlueprintBundle)m)));
    }

    public Map<String, Blueprint> getBlueprints(GameModeAddon addon) {
        if (!this.blueprints.containsKey(addon)) {
            return new HashMap<String, Blueprint>();
        }
        return this.blueprints.get(addon).stream().collect(Collectors.toMap(Blueprint::getName, b -> b));
    }

    public void deleteBlueprint(GameModeAddon addon, String name) {
        List<Blueprint> addonBlueprints = this.blueprints.get(addon);
        Iterator<Blueprint> it = addonBlueprints.iterator();
        while (it.hasNext()) {
            Blueprint b = it.next();
            if (!b.getName().equalsIgnoreCase(name)) continue;
            it.remove();
            File file = new File(this.getBlueprintsFolder(addon), b.getName() + BLUEPRINT_SUFFIX);
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                this.plugin.logError("Could not delete Blueprint " + e.getLocalizedMessage());
            }
        }
    }

    public void paste(GameModeAddon addon, Island island, String name) {
        this.paste(addon, island, name, null, true);
    }

    public boolean paste(GameModeAddon addon, Island island, String name, Runnable task, boolean useNMS) {
        if (this.validate(addon, name) == null) {
            this.plugin.logError("Tried to paste '" + name + "' but the bundle is not loaded!");
            return false;
        }
        BlueprintBundle bb = this.getBlueprintBundles(addon).get(name.toLowerCase());
        if (!this.blueprints.containsKey(addon) || this.blueprints.get(addon).isEmpty()) {
            this.plugin.logError("No blueprints loaded for bundle '" + name + "'!");
            return false;
        }
        Blueprint bp = this.getBlueprints(addon).get(bb.getBlueprint(World.Environment.NORMAL));
        if (bp == null) {
            bp = this.getBlueprints(addon).get("island");
            this.plugin.logError("Blueprint bundle has no normal world blueprint, using default");
            if (bp == null) {
                this.plugin.logError("NO DEFAULT BLUEPRINT FOUND! Make sure 'island.blu' exists!");
            }
        }
        if (bp != null) {
            new BlueprintPaster(this.plugin, bp, addon.getOverWorld(), island).paste(useNMS).thenAccept(b -> this.pasteNether(addon, bb, island).thenAccept(b2 -> ((CompletableFuture)this.pasteEnd(addon, bb, island).thenAccept(message -> this.sendMessage(island))).thenAccept(b3 -> Bukkit.getScheduler().runTask((Plugin)this.plugin, task))));
        }
        island.putMetaData("bundle", new MetaDataValue(name));
        return true;
    }

    private CompletableFuture<Boolean> pasteNether(GameModeAddon addon, BlueprintBundle bb, Island island) {
        Blueprint bp;
        if (bb.getBlueprint(World.Environment.NETHER) != null && addon.getWorldSettings().isNetherGenerate() && addon.getWorldSettings().isNetherIslands() && addon.getNetherWorld() != null && (bp = this.getBlueprints(addon).get(bb.getBlueprint(World.Environment.NETHER))) != null) {
            return new BlueprintPaster(this.plugin, bp, addon.getNetherWorld(), island).paste();
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<Boolean> pasteEnd(GameModeAddon addon, BlueprintBundle bb, Island island) {
        Blueprint bp;
        if (bb.getBlueprint(World.Environment.THE_END) != null && addon.getWorldSettings().isEndGenerate() && addon.getWorldSettings().isEndIslands() && addon.getEndWorld() != null && (bp = this.getBlueprints(addon).get(bb.getBlueprint(World.Environment.THE_END))) != null) {
            return new BlueprintPaster(this.plugin, bp, addon.getEndWorld(), island).paste();
        }
        return CompletableFuture.completedFuture(false);
    }

    private void sendMessage(Island island) {
        if (island != null && island.getOwner() != null) {
            Optional<User> owner = Optional.of(island).map(i -> User.getInstance(i.getOwner()));
            owner.ifPresent(user -> user.sendMessage("commands.island.create.pasting.done", new String[0]));
        }
    }

    public @Nullable String validate(GameModeAddon addon, String name) {
        if (name == null) {
            return null;
        }
        if (this.blueprintBundles.containsKey(addon) && this.getBlueprintBundles(addon).containsKey(name)) {
            return name;
        }
        return null;
    }

    public void addBlueprintBundle(GameModeAddon addon, BlueprintBundle bb) {
        if (this.blueprintBundles.containsKey(addon)) {
            this.blueprintBundles.get(addon).removeIf(b -> b.getUniqueId().equals(bb.getUniqueId()));
        }
        this.blueprintBundles.computeIfAbsent(addon, k -> new ArrayList()).add(bb);
    }

    public boolean checkPerm(@NonNull Addon addon, @NonNull User user, @NonNull String name) {
        String permission = addon.getPermissionPrefix() + "island.create." + name;
        BlueprintBundle bb = this.getBlueprintBundles((GameModeAddon)addon).get(name.toLowerCase());
        if (bb == null || bb.isRequirePermission() && !name.equals(DEFAULT_BUNDLE_NAME) && !user.hasPermission(permission)) {
            user.sendMessage("general.errors.no-permission", "[permission]", permission);
            return false;
        }
        return true;
    }

    public void deleteBlueprintBundle(@NonNull GameModeAddon addon, BlueprintBundle bb) {
        if (this.blueprintBundles.containsKey(addon)) {
            this.blueprintBundles.get(addon).removeIf(k -> k.getUniqueId().equals(bb.getUniqueId()));
        }
        File bpf = this.getBlueprintsFolder(addon);
        File fileName = new File(bpf, bb.getUniqueId() + BLUEPRINT_BUNDLE_SUFFIX);
        try {
            Files.deleteIfExists(fileName.toPath());
        }
        catch (IOException e) {
            this.plugin.logError("Could not delete Blueprint Bundle " + e.getLocalizedMessage());
        }
    }

    public void renameBlueprint(GameModeAddon addon, Blueprint bp, String name, String displayName) {
        if (bp.getName().equalsIgnoreCase(name)) {
            return;
        }
        File bpf = this.getBlueprintsFolder(addon);
        File fileName = new File(bpf, bp.getName() + BLUEPRINT_SUFFIX);
        try {
            Files.deleteIfExists(fileName.toPath());
        }
        catch (IOException e) {
            this.plugin.logError("Could not delete old Blueprint " + e.getLocalizedMessage());
        }
        this.blueprints.get(addon).remove(bp);
        bp.setName(name);
        bp.setDisplayName(displayName);
        this.saveBlueprint(addon, bp);
        this.addBlueprint(addon, bp);
    }
}

