/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;

public class CommandsManager {
    private final @NonNull Map<@NonNull String, @NonNull CompositeCommand> commands = new HashMap<String, CompositeCommand>();
    private SimpleCommandMap commandMap;

    public void registerCommand(@NonNull CompositeCommand command) {
        this.commands.put(command.getLabel(), command);
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            this.commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getServer());
            String commandPrefix = "bentobox";
            if (command.getAddon() != null) {
                commandPrefix = ((Addon)command.getAddon()).getDescription().getName().toLowerCase(Locale.ENGLISH);
            }
            if (!this.commandMap.register(commandPrefix, (Command)command)) {
                BentoBox.getInstance().logError("Failed to register command " + commandPrefix + " " + command.getLabel());
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().severe("Bukkit server commandMap method is not there! This means no commands can be registered!");
        }
    }

    public void unregisterCommands() {
        try {
            Map knownCommands = (Map)this.commandMap.getClass().getMethod("getKnownCommands", new Class[0]).invoke((Object)this.commandMap, new Object[0]);
            knownCommands.values().removeIf(this.commands.values()::contains);
            this.commands.values().forEach(c -> c.unregister((CommandMap)this.commandMap));
            this.commands.clear();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Known commands reflection was not possible, BentoBox is now unstable, so restart server!");
        }
    }

    public @Nullable CompositeCommand getCommand(@NonNull String command) {
        return this.commands.get(command);
    }

    public @NonNull Map<String, CompositeCommand> getCommands() {
        return this.commands;
    }

    public @NonNull Set<String> listCommands() {
        return this.commands.keySet();
    }
}

