/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.placeholders.PlaceholderReplacer;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.hooks.placeholders.PlaceholderAPIHook;
import world.bentobox.bentobox.lists.GameModePlaceholder;
import world.bentobox.bentobox.managers.RanksManager;

public class PlaceholdersManager {
    private static final int MAX_TEAM_MEMBER_PLACEHOLDERS = 50;
    private final BentoBox plugin;

    public PlaceholdersManager(BentoBox plugin) {
        this.plugin = plugin;
    }

    public void registerPlaceholder(@NonNull String placeholder, @NonNull PlaceholderReplacer replacer) {
        this.getPlaceholderAPIHook().ifPresent(hook -> hook.registerPlaceholder(placeholder, replacer));
    }

    public void registerPlaceholder(@Nullable Addon addon, @NonNull String placeholder, @NonNull PlaceholderReplacer replacer) {
        if (addon == null) {
            this.registerPlaceholder(placeholder, replacer);
            return;
        }
        this.getPlaceholderAPIHook().ifPresent(hook -> hook.registerPlaceholder(addon, placeholder, replacer));
    }

    public void registerDefaultPlaceholders(@NonNull GameModeAddon addon) {
        Arrays.stream(GameModePlaceholder.values()).filter(placeholder -> !this.isPlaceholder(addon, placeholder.getPlaceholder())).forEach(placeholder -> this.registerPlaceholder(addon, placeholder.getPlaceholder(), new DefaultPlaceholder(this, addon, (GameModePlaceholder)((Object)placeholder))));
        this.registerTeamMemberPlaceholders(addon);
        this.registerOwnedIslandPlaceholders(addon);
    }

    private void registerOwnedIslandPlaceholders(@NonNull GameModeAddon addon) {
        int maxIslands = this.plugin.getIWM().getWorldSettings(addon.getOverWorld()).getConcurrentIslands();
        IntStream.range(0, maxIslands).forEach(i -> this.registerPlaceholder(addon, "island_name_" + (i + 1), user -> {
            if (user == null) {
                return "";
            }
            AtomicInteger generatedCount = new AtomicInteger(1);
            return this.plugin.getIslands().getIslands(addon.getOverWorld(), user).stream().map(island -> {
                IslandName islandName = this.getIslandName((Island)island, user, generatedCount.get());
                if (islandName.generatated()) {
                    generatedCount.getAndIncrement();
                }
                return islandName.name;
            }).skip(i).findFirst().orElse("");
        }));
        IntStream.range(0, maxIslands).forEach(i -> this.registerPlaceholder(addon, "island_memberlist_" + (i + 1), user -> user == null ? "" : this.plugin.getIslands().getIslands(addon.getOverWorld(), user).stream().skip(i).findFirst().map(island -> island.getMemberSet().stream().map(addon.getPlayers()::getName).collect(Collectors.joining(","))).orElse("")));
    }

    private IslandName getIslandName(Island island, User user, int index) {
        if (island.getName() != null && !island.getName().isBlank()) {
            return new IslandName(island.getName(), false);
        }
        return new IslandName(user.getTranslation("protection.flags.ENTER_EXIT_MESSAGES.island", "[name]", user.getName(), "[display_name]", user.getDisplayName()) + " " + index, true);
    }

    private void registerTeamMemberPlaceholders(@NonNull GameModeAddon addon) {
        for (int i = 1; i <= 50; ++i) {
            int count = i;
            this.registerPlaceholder(addon, "island_member_name_" + i, user -> {
                if (user != null) {
                    Island island = this.plugin.getIslands().getIsland(addon.getOverWorld(), user);
                    int j = 1;
                    for (UUID uuid : island.getMemberSet(500)) {
                        if (j++ != count) continue;
                        return this.plugin.getPlayers().getName(uuid);
                    }
                }
                return "";
            });
            this.registerPlaceholder(addon, "island_member_rank_" + i, user -> {
                if (user != null) {
                    Island island = this.plugin.getIslands().getIsland(addon.getOverWorld(), user);
                    int j = 1;
                    for (UUID uuid : island.getMemberSet(500)) {
                        if (j++ != count) continue;
                        return user.getTranslationOrNothing(RanksManager.getInstance().getRank(island.getRank(uuid)), new String[0]);
                    }
                }
                return "";
            });
            this.registerPlaceholder(addon, "island_banned_name_" + i, user -> {
                if (user != null) {
                    Island island = this.plugin.getIslands().getIsland(addon.getOverWorld(), user);
                    int j = 1;
                    for (UUID uuid : island.getBanned()) {
                        if (j++ != count) continue;
                        return this.plugin.getPlayers().getName(uuid);
                    }
                }
                return "";
            });
            this.registerPlaceholder(addon, "visited_island_member_name_" + i, user -> {
                if (user != null) {
                    return this.plugin.getIslands().getIslandAt(user.getLocation()).filter(island -> addon.inWorld(island.getCenter())).map(island -> {
                        int j = 1;
                        for (UUID uuid : island.getMemberSet(500)) {
                            if (j++ != count) continue;
                            return this.plugin.getPlayers().getName(uuid);
                        }
                        return "";
                    }).orElse("");
                }
                return "";
            });
            this.registerPlaceholder(addon, "visited_island_member_rank_" + i, user -> {
                if (user != null) {
                    return this.plugin.getIslands().getIslandAt(user.getLocation()).filter(island -> addon.inWorld(island.getCenter())).map(island -> {
                        int j = 1;
                        for (UUID uuid : island.getMemberSet(500)) {
                            if (j++ != count) continue;
                            return user.getTranslationOrNothing(RanksManager.getInstance().getRank(island.getRank(uuid)), new String[0]);
                        }
                        return "";
                    }).orElse("");
                }
                return "";
            });
            this.registerPlaceholder(addon, "visited_island_banned_name_" + i, user -> {
                if (user != null) {
                    return this.plugin.getIslands().getIslandAt(user.getLocation()).filter(island -> addon.inWorld(island.getCenter())).map(island -> {
                        int j = 1;
                        for (UUID uuid : island.getBanned()) {
                            if (j++ != count) continue;
                            return this.plugin.getPlayers().getName(uuid);
                        }
                        return "";
                    }).orElse("");
                }
                return "";
            });
        }
        this.registerPlaceholder(addon, "island_online_members_count", user -> {
            if (user == null) {
                return "";
            }
            Island island = this.plugin.getIslands().getIsland(addon.getOverWorld(), user);
            return island != null ? String.valueOf(island.getMemberSet(500).stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).count()) : "";
        });
        this.registerPlaceholder(addon, "visited_island_online_members_count", user -> {
            if (user == null) {
                return "";
            }
            return this.plugin.getIslands().getIslandAt(user.getLocation()).map(island -> String.valueOf(island.getMemberSet(500).stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).count())).orElse("");
        });
    }

    public void unregisterPlaceholder(@NonNull String placeholder) {
        this.getPlaceholderAPIHook().ifPresent(hook -> hook.unregisterPlaceholder(placeholder));
    }

    public void unregisterPlaceholder(@Nullable Addon addon, @NonNull String placeholder) {
        if (addon == null) {
            this.unregisterPlaceholder(placeholder);
            return;
        }
        this.getPlaceholderAPIHook().ifPresent(hook -> hook.unregisterPlaceholder(addon, placeholder));
    }

    private @NonNull Optional<PlaceholderAPIHook> getPlaceholderAPIHook() {
        return this.plugin.getHooks().getHook("PlaceholderAPI").map(PlaceholderAPIHook.class::cast);
    }

    public boolean isPlaceholder(@NonNull Addon addon, @NonNull String placeholder) {
        return this.getPlaceholderAPIHook().map(h -> h.isPlaceholder(addon, placeholder)).orElse(false);
    }

    public String replacePlaceholders(@Nullable Player player, @NonNull String string) {
        return this.getPlaceholderAPIHook().map(papi -> papi.replacePlaceholders(player, string)).orElse(string);
    }

    public void unregisterAll() {
        this.getPlaceholderAPIHook().ifPresent(PlaceholderAPIHook::unregisterAll);
    }

    private record IslandName(String name, boolean generatated) {
    }

    class DefaultPlaceholder
    implements PlaceholderReplacer {
        private final GameModeAddon addon;
        private final GameModePlaceholder type;

        public DefaultPlaceholder(PlaceholdersManager this$0, GameModeAddon addon, GameModePlaceholder type) {
            this.addon = addon;
            this.type = type;
        }

        @Override
        public @NonNull String onReplace(@Nullable User user) {
            if (user == null) {
                return "";
            }
            Island island = this.addon.getIslands().getIsland(this.addon.getOverWorld(), user);
            return this.type.getReplacer().onReplace(this.addon, user, island);
        }
    }
}

