/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.Names;
import world.bentobox.bentobox.database.objects.Players;
import world.bentobox.bentobox.util.ExpiringMap;
import world.bentobox.bentobox.util.Util;

public class PlayersManager {
    private final BentoBox plugin;
    private Database<Players> handler;
    private final Database<Names> names;
    private final ExpiringMap<UUID, Players> playerCache = new ExpiringMap(2L, TimeUnit.HOURS);
    private final @NonNull List<Names> nameCache;
    private final Set<UUID> inTeleport;

    public PlayersManager(BentoBox plugin) {
        this.plugin = plugin;
        this.handler = new Database<Players>(plugin, Players.class);
        this.names = new Database<Names>(plugin, Names.class);
        this.nameCache = this.names.loadObjects();
        this.inTeleport = new HashSet<UUID>();
    }

    public void setHandler(Database<Players> handler) {
        this.handler = handler;
    }

    public void shutdown() {
        this.playerCache.forEach((uuid, player) -> this.handler.saveObject((Players)player));
        this.handler.close();
        this.playerCache.shutdown();
    }

    public @Nullable Players getPlayer(UUID uuid) {
        return this.playerCache.computeIfAbsent(uuid, this::addPlayer);
    }

    private Players addPlayer(@NonNull UUID playerUUID) {
        Players p;
        Objects.requireNonNull(playerUUID, "Player UUID must not be null");
        if (this.handler.objectExists(playerUUID.toString()) && (p = this.loadPlayer(playerUUID)) != null) {
            return p;
        }
        Players newPlayer = new Players(this.plugin, playerUUID);
        this.handler.saveObjectAsync(newPlayer);
        return newPlayer;
    }

    public @Nullable Players loadPlayer(UUID uuid) {
        return this.handler.loadObject(uuid.toString());
    }

    public @NonNull Collection<Players> getPlayers() {
        return Collections.unmodifiableCollection(this.handler.loadObjects());
    }

    public boolean isKnown(UUID uniqueID) {
        return uniqueID == null ? false : this.handler.objectExists(uniqueID.toString());
    }

    public @Nullable UUID getUUID(@NonNull String name) {
        if (name.length() == 36 && name.contains("-")) {
            try {
                return UUID.fromString(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.nameCache.stream().filter(n -> n.getUniqueId().equalsIgnoreCase(name)).findFirst().map(Names::getUuid).orElse(null);
    }

    public void setPlayerName(@NonNull User user) {
        if (user.getUniqueId() == null) {
            return;
        }
        Players player = this.getPlayer(user.getUniqueId());
        player.setPlayerName(user.getName());
        this.handler.saveObject(player);
        Names newName = new Names(user.getName(), user.getUniqueId());
        this.nameCache.removeIf(name -> user.getUniqueId().equals(name.getUuid()));
        this.nameCache.add(newName);
        this.names.saveObjectAsync(newName);
    }

    public @NonNull String getName(@Nullable UUID playerUUID) {
        if (playerUUID == null) {
            return "";
        }
        this.getPlayer(playerUUID);
        return Objects.requireNonNullElse(this.playerCache.get(playerUUID).getPlayerName(), "");
    }

    public int getResets(World world, UUID playerUUID) {
        return this.getPlayer(playerUUID).getResets(world);
    }

    public int getResetsLeft(World world, UUID playerUUID) {
        this.getPlayer(playerUUID);
        if (this.plugin.getIWM().getResetLimit(world) == -1) {
            return -1;
        }
        return Math.max(this.plugin.getIWM().getResetLimit(world) - this.getResets(world, playerUUID), 0);
    }

    public void setResets(World world, UUID playerUUID, int resets) {
        Players p = this.getPlayer(playerUUID);
        p.setResets(world, resets);
        this.handler.saveObject(p);
    }

    public String getLocale(UUID playerUUID) {
        return this.getPlayer(playerUUID).getLocale();
    }

    public void setLocale(UUID playerUUID, String localeName) {
        Players p = this.getPlayer(playerUUID);
        p.setLocale(localeName);
        this.handler.saveObject(p);
    }

    public void addDeath(World world, UUID playerUUID) {
        Players p = this.getPlayer(playerUUID);
        p.addDeath(world);
        this.handler.saveObject(p);
    }

    public void setDeaths(World world, UUID playerUUID, int deaths) {
        Players p = this.getPlayer(playerUUID);
        p.setDeaths(world, deaths);
        this.handler.saveObject(p);
    }

    public int getDeaths(World world, UUID playerUUID) {
        return this.getPlayer(playerUUID).getDeaths(world);
    }

    public void setInTeleport(UUID uniqueId) {
        this.inTeleport.add(uniqueId);
    }

    public void removeInTeleport(UUID uniqueId) {
        this.inTeleport.remove(uniqueId);
    }

    public boolean isInTeleport(UUID uniqueId) {
        return this.inTeleport.contains(uniqueId);
    }

    public User getUser(String name) {
        UUID uuid = this.getUUID(name);
        return uuid == null ? null : this.getUser(uuid);
    }

    public User getUser(UUID uuid) {
        return User.getInstance(uuid);
    }

    public void addReset(World world, UUID playerUUID) {
        Players p = this.getPlayer(playerUUID);
        p.addReset(world);
        this.handler.saveObject(p);
    }

    public void removePlayer(Player player) {
        this.handler.deleteID(player.getUniqueId().toString());
    }

    public void cleanLeavingPlayer(World world, User target, boolean kicked, Island island) {
        Players p;
        String ownerName = this.getName(island.getOwner());
        Util.runCommands(target, ownerName, this.plugin.getIWM().getOnLeaveCommands(world), "leave");
        world.getEntitiesByClass(Tameable.class).stream().filter(Tameable::isTamed).filter(t -> t.getOwner() != null && t.getOwner().getUniqueId().equals(target.getUniqueId())).forEach(t -> t.setOwner(null));
        if (this.plugin.getIWM().isOnLeaveResetEnderChest(world)) {
            if (target.isOnline()) {
                target.getPlayer().getEnderChest().clear();
            } else {
                p = this.getPlayer(target.getUniqueId());
                if (p != null) {
                    p.addToPendingKick(world);
                }
            }
        }
        if (kicked && this.plugin.getIWM().isOnLeaveResetInventory(world) && !this.plugin.getIWM().isKickedKeepInventory(world) || !kicked && this.plugin.getIWM().isOnLeaveResetInventory(world)) {
            if (target.isOnline()) {
                target.getPlayer().getInventory().clear();
            } else {
                p = this.getPlayer(target.getUniqueId());
                if (p != null) {
                    p.addToPendingKick(world);
                }
            }
        }
        if (this.plugin.getSettings().isUseEconomy() && this.plugin.getIWM().isOnLeaveResetMoney(world)) {
            this.plugin.getVault().ifPresent(vault -> vault.withdraw(target, vault.getBalance(target), world));
        }
        if (this.plugin.getIWM().isOnLeaveResetHealth(world) && target.isPlayer()) {
            Util.resetHealth(target.getPlayer());
        }
        if (this.plugin.getIWM().isOnLeaveResetHunger(world) && target.isPlayer()) {
            target.getPlayer().setFoodLevel(20);
        }
        if (this.plugin.getIWM().isOnLeaveResetXP(world) && target.isPlayer()) {
            target.getPlayer().setLevel(0);
            target.getPlayer().setExp(0.0f);
            target.getPlayer().setTotalExperience(0);
        }
    }

    public CompletableFuture<Boolean> savePlayer(UUID uuid) {
        Players p = this.getPlayer(uuid);
        if (p != null) {
            return this.handler.saveObjectAsync(p);
        }
        return CompletableFuture.completedFuture(false);
    }

    public void setLoginTimeStamp(User user) {
        if (user.isPlayer() && user.isOnline()) {
            this.setLoginTimeStamp(user.getUniqueId(), System.currentTimeMillis());
        }
    }

    public void setLoginTimeStamp(UUID playerUUID, long timestamp) {
        Players p = this.getPlayer(playerUUID);
        if (p != null) {
            p.setLastLogin(timestamp);
            this.savePlayer(playerUUID);
        }
    }

    public @Nullable Long getLastLoginTimestamp(UUID uuid) {
        Players p = this.getPlayer(uuid);
        if (p != null) {
            return p.getLastLogin();
        }
        return null;
    }
}

