/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers.island;

import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.IslandCache;

class IslandGrid {
    private final TreeMap<Integer, TreeMap<Integer, IslandData>> grid = new TreeMap();
    private final IslandCache im;

    public IslandGrid(IslandCache im) {
        this.im = im;
    }

    public boolean addToGrid(Island island) {
        int minX = island.getMinX();
        int minZ = island.getMinZ();
        IslandData islandData = new IslandData(island.getUniqueId(), minX, minZ, island.getRange());
        if (this.grid.containsKey(minX)) {
            TreeMap<Integer, IslandData> zEntry = this.grid.get(minX);
            if (zEntry.containsKey(minZ)) {
                return island.getUniqueId().equals(zEntry.get(minZ).id());
            }
            zEntry.put(minZ, islandData);
            this.grid.put(minX, zEntry);
        } else {
            TreeMap<Integer, IslandData> zEntry = new TreeMap<Integer, IslandData>();
            zEntry.put(minZ, islandData);
            this.grid.put(minX, zEntry);
        }
        return true;
    }

    public boolean removeFromGrid(Island island) {
        String id = island.getUniqueId();
        boolean removed = this.grid.values().stream().anyMatch(innerMap -> innerMap.values().removeIf(innerValue -> innerValue.id().equals(id)));
        this.grid.values().removeIf(AbstractMap::isEmpty);
        return removed;
    }

    public Island getIslandAt(int x, int z) {
        String id = this.getIslandStringAt(x, z);
        if (id == null) {
            return null;
        }
        return this.im.getIslandById(id);
    }

    public boolean isIslandAt(int x, int z) {
        return this.getIslandStringAt(x, z) != null;
    }

    public @Nullable String getIslandStringAt(int x, int z) {
        Map.Entry<Integer, TreeMap<Integer, IslandData>> xEntry = this.grid.floorEntry(x);
        if (xEntry == null) {
            return null;
        }
        Map.Entry<Integer, IslandData> zEntry = xEntry.getValue().floorEntry(z);
        if (zEntry == null) {
            return null;
        }
        if (x >= zEntry.getValue().minX() && x < zEntry.getValue().minX() + zEntry.getValue().range() * 2 && z >= zEntry.getValue().minZ() && z < zEntry.getValue().minZ() + zEntry.getValue().range() * 2) {
            return zEntry.getValue().id();
        }
        return null;
    }

    public long getSize() {
        long count = 0L;
        for (TreeMap<Integer, IslandData> innerMap : this.grid.values()) {
            count += (long)innerMap.size();
        }
        return count;
    }

    private record IslandData(String id, int minX, int minZ, int range) {
    }
}

