/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels;

import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelBuilder;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.web.credits.Contributor;

public class CreditsPanel {
    private static final String LOCALE_REF = "panel.credits.";
    private static final int[] PANES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    private CreditsPanel() {
    }

    public static void openPanel(User user, String repository) {
        BentoBox plugin = BentoBox.getInstance();
        PanelBuilder builder = new PanelBuilder().name(user.getTranslation("panel.credits.title", "[name]", repository.split("/")[1])).size(45);
        for (int i : PANES) {
            builder.item(i, new PanelItemBuilder().icon(plugin.getSettings().getPanelFillerMaterial()).name(" ").build());
        }
        if (plugin.getWebManager().getContributors(repository).isEmpty()) {
            CreditsPanel.looksEmpty(builder, user);
        } else {
            Object object = plugin.getWebManager().getContributors(repository).iterator();
            while (object.hasNext()) {
                Contributor contributor = (Contributor)object.next();
                int slot = CreditsPanel.getFirstAvailableSlot(builder);
                if (slot == -1) break;
                PanelItem contributorItem = new PanelItemBuilder().icon(contributor.getName()).name(user.getTranslation("panel.credits.contributor.name", "[name]", contributor.getName())).description(user.getTranslation("panel.credits.contributor.description", "[commits]", String.valueOf(contributor.getCommits()))).clickHandler((panel, user1, clickType, slot1) -> {
                    user.sendRawMessage(String.valueOf(NamedTextColor.GRAY) + contributor.getURL());
                    return true;
                }).build();
                builder.item(CreditsPanel.getFirstAvailableSlot(builder), contributorItem);
            }
        }
        builder.build().open(user);
    }

    public static void openPanel(User user, Addon addon) {
        CreditsPanel.openPanel(user, addon.getDescription().getRepository());
    }

    private static void looksEmpty(@NonNull PanelBuilder builder, @NonNull User user) {
        PanelItem emptyHere = new PanelItemBuilder().icon(Material.STRUCTURE_VOID).name(user.getTranslation("panel.credits.empty-here.name", new String[0])).description(user.getTranslation("panel.credits.empty-here.description", new String[0])).build();
        builder.item(22, emptyHere);
    }

    private static int getFirstAvailableSlot(PanelBuilder pb) {
        for (int i = 0; i < 35; ++i) {
            if (pb.slotOccupied(i)) continue;
            return i;
        }
        return -1;
    }
}

