/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.panels.PanelListener;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.panels.BlueprintManagementPanel;

public class IconChanger
implements PanelListener {
    private final GameModeAddon addon;
    private final BlueprintBundle bb;
    private final BlueprintManagementPanel blueprintManagementPanel;
    private final BentoBox plugin;

    public IconChanger(BentoBox plugin, GameModeAddon addon, BlueprintManagementPanel blueprintManagementPanel, BlueprintBundle bb) {
        this.plugin = plugin;
        this.addon = addon;
        this.blueprintManagementPanel = blueprintManagementPanel;
        this.bb = bb;
    }

    @Override
    public void onInventoryClick(User user, InventoryClickEvent event) {
        if (event.getCurrentItem() != null && !event.getCurrentItem().getType().equals((Object)Material.AIR) && event.getRawSlot() > 44) {
            Material icon = event.getCurrentItem().getType();
            Map.Entry<Integer, Blueprint> selected = this.blueprintManagementPanel.getSelected();
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            if (selected == null) {
                this.bb.setIcon(icon);
                this.plugin.getBlueprintsManager().saveBlueprintBundle(this.addon, this.bb);
            } else {
                Blueprint bp = selected.getValue();
                bp.setIcon(icon);
                this.plugin.getBlueprintsManager().saveBlueprint(this.addon, bp);
            }
            this.blueprintManagementPanel.openBB(this.bb);
        }
    }

    @Override
    public void onInventoryClose(InventoryCloseEvent event) {
    }

    @Override
    public void setup() {
    }
}

