/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.settings;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.island.conversations.ConfirmPrompt;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.Tab;
import world.bentobox.bentobox.api.panels.TabbedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class SettingsTab
implements Tab,
PanelItem.ClickHandler {
    protected static final String PROTECTION_PANEL = "protection.panel.";
    private static final String CLICK_TO_SWITCH = "protection.panel.mode.click-to-switch";
    protected BentoBox plugin = BentoBox.getInstance();
    protected Flag.Type type;
    protected User user;
    protected World world;
    protected Island island;
    protected TabbedPanel parent;
    private Map<UUID, Flag.Mode> currentMode = new HashMap<UUID, Flag.Mode>();

    public SettingsTab(World world, User user, Flag.Type type) {
        this.world = world;
        this.user = user;
        this.type = type;
    }

    public SettingsTab(World world, User user, Flag.Type type, Flag.Mode defaultMode) {
        this.world = world;
        this.user = user;
        this.type = type;
        this.currentMode.put(user.getUniqueId(), defaultMode);
    }

    protected List<Flag> getFlags() {
        List<Flag> flags = this.plugin.getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)this.type)).sorted(Comparator.comparing(flag -> Util.stripColor(this.user.getTranslation(flag.getNameReference(), new String[0])))).collect(Collectors.toList());
        this.plugin.getIWM().getAddon(this.world).ifPresent(gm -> flags.removeIf(f -> !f.getGameModes().isEmpty() && !f.getGameModes().contains(gm)));
        Flag.Mode mode = this.currentMode.getOrDefault(this.user.getUniqueId(), Flag.Mode.BASIC);
        this.plugin.getIWM().getAddon(this.world).ifPresent(gm -> flags.removeIf(f -> f.getMode().isGreaterThan(mode) || f.getMode().equals((Object)Flag.Mode.TOP_ROW)));
        return flags;
    }

    @Override
    public PanelItem getIcon() {
        PanelItemBuilder pib = new PanelItemBuilder();
        pib.icon(this.type.getIcon());
        pib.name(this.getName());
        pib.description(this.user.getTranslation(PROTECTION_PANEL + this.type.toString() + ".description", new String[0]));
        return pib.build();
    }

    @Override
    public String getName() {
        return this.user.getTranslation(PROTECTION_PANEL + this.type.toString() + ".title", "[world_name]", this.plugin.getIWM().getFriendlyName(this.world));
    }

    @Override
    public @NonNull List<@Nullable PanelItem> getPanelItems() {
        List<Flag> flags = this.getFlags();
        int i = 0;
        while (flags.isEmpty() && i++ < Flag.Mode.values().length) {
            this.currentMode.put(this.user.getUniqueId(), this.currentMode.getOrDefault(this.user.getUniqueId(), Flag.Mode.BASIC).getNext());
            flags = this.getFlags();
        }
        HashSet toBeRemoved = new HashSet();
        flags.forEach(flag -> {
            if (flag.isSubFlag() && flag.getHideWhen() != Flag.HideWhen.NEVER) {
                if (!flag.getParentFlag().isSetForWorld(this.world) && flag.getHideWhen() == Flag.HideWhen.SETTING_FALSE) {
                    toBeRemoved.add(flag);
                } else if (flag.getParentFlag().isSetForWorld(this.world) && flag.getHideWhen() == Flag.HideWhen.SETTING_TRUE) {
                    toBeRemoved.add(flag);
                }
            }
        });
        flags.removeAll(toBeRemoved);
        List<@Nullable PanelItem> result = flags.stream().map(f -> f.toPanelItem(this.plugin, this.user, this.world, this.island, this.plugin.getIWM().getHiddenFlags(this.world).contains(f.getID()))).toList();
        return result;
    }

    @Override
    public Map<Integer, PanelItem> getTabIcons() {
        HashMap<Integer, PanelItem> icons = new HashMap<Integer, PanelItem>();
        if (this.island != null) {
            icons.put(4, Flags.CHANGE_SETTINGS.toPanelItem(this.plugin, this.user, this.world, this.island, false));
            icons.put(5, Flags.LOCK.toPanelItem(this.plugin, this.user, this.world, this.island, false));
        }
        switch (this.currentMode.getOrDefault(this.user.getUniqueId(), Flag.Mode.BASIC)) {
            case ADVANCED: {
                icons.put(7, new PanelItemBuilder().icon(Material.GOLD_INGOT).name(this.user.getTranslation("protection.panel.mode.advanced.name", new String[0])).description(this.user.getTranslation("protection.panel.mode.advanced.description", new String[0]), "", this.user.getTranslation(CLICK_TO_SWITCH, "[next]", this.user.getTranslation("protection.panel.mode.expert.name", new String[0]))).clickHandler(this).build());
                break;
            }
            case EXPERT: {
                icons.put(7, new PanelItemBuilder().icon(Material.NETHER_BRICK).name(this.user.getTranslation("protection.panel.mode.expert.name", new String[0])).description(this.user.getTranslation("protection.panel.mode.expert.description", new String[0]), "", this.user.getTranslation(CLICK_TO_SWITCH, "[next]", this.user.getTranslation("protection.panel.mode.basic.name", new String[0]))).clickHandler(this).build());
                break;
            }
            default: {
                icons.put(7, new PanelItemBuilder().icon(Material.IRON_INGOT).name(this.user.getTranslation("protection.panel.mode.basic.name", new String[0])).description(this.user.getTranslation("protection.panel.mode.basic.description", new String[0]), "", this.user.getTranslation(CLICK_TO_SWITCH, "[next]", this.user.getTranslation("protection.panel.mode.advanced.name", new String[0]))).clickHandler(this).build());
            }
        }
        if (this.island != null && this.user.getUniqueId().equals(this.island.getOwner())) {
            icons.put(8, new PanelItemBuilder().icon(Material.TNT).name(this.user.getTranslation("protection.panel.reset-to-default.name", new String[0])).description(this.user.getTranslation("protection.panel.reset-to-default.description", new String[0])).clickHandler((panel, user1, clickType, slot) -> {
                this.user.closeInventory();
                String confirmation = this.user.getTranslationOrNothing("protection.panel.reset-to-default.confirm", new String[0]);
                if (confirmation.isBlank()) {
                    confirmation = "confirm";
                }
                new ConversationFactory((Plugin)BentoBox.getInstance()).withModality(true).withLocalEcho(false).withTimeout(90).withFirstPrompt((Prompt)new ConfirmPrompt(this.user, this.plugin, "protection.panel.reset-to-default.instructions", confirmation, () -> {
                    this.island.setFlagsDefaults();
                    this.user.getPlayer().playSound(this.user.getLocation(), Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
                })).buildConversation((Conversable)this.user.getPlayer()).begin();
                return true;
            }).build());
        }
        return icons;
    }

    @Override
    public String getPermission() {
        return "";
    }

    public Flag.Type getType() {
        return this.type;
    }

    public User getUser() {
        return this.user;
    }

    public World getWorld() {
        return this.world;
    }

    public Island getIsland() {
        return this.island;
    }

    @Override
    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        this.currentMode.put(user.getUniqueId(), this.currentMode.getOrDefault(user.getUniqueId(), Flag.Mode.BASIC).getNext());
        if (panel instanceof TabbedPanel) {
            TabbedPanel tp = (TabbedPanel)panel;
            tp.setActivePage(0);
            tp.refreshPanel();
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public TabbedPanel getParentPanel() {
        return this.parent;
    }

    @Override
    public void setParentPanel(TabbedPanel parent) {
        this.parent = parent;
        this.island = parent.getIsland();
        this.world = parent.getWorld().orElse(this.world);
    }
}

