/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ExpiringMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final ScheduledExecutorService scheduler;
    private final long expirationTime;

    public ExpiringMap(long expirationTime, TimeUnit timeUnit) {
        if (expirationTime <= 0L) {
            throw new IllegalArgumentException("Expiration time must be greater than zero.");
        }
        if (timeUnit == null) {
            throw new NullPointerException("TimeUnit cannot be null.");
        }
        this.map = new ConcurrentHashMap();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.expirationTime = timeUnit.toMillis(expirationTime);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("Key and Value cannot be null.");
        }
        V oldValue = this.map.put(key, value);
        this.scheduleRemoval(key);
        return oldValue;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        return this.map.get(key);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new NullPointerException("The specified map cannot be null.");
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (key == null || mappingFunction == null) {
            throw new NullPointerException("Key and mappingFunction cannot be null.");
        }
        return (V)this.map.computeIfAbsent(key, k -> {
            Object value = mappingFunction.apply((K)k);
            this.scheduleRemoval(k);
            return value;
        });
    }

    private void scheduleRemoval(K key) {
        this.scheduler.schedule(() -> this.map.remove(key), this.expirationTime, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

