/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import com.google.common.base.Enums;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerProfile;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;

public class ItemParser {
    private ItemParser() {
    }

    public static ItemStack parse(String text) {
        return ItemParser.parse(text, null);
    }

    public static @Nullable ItemStack parse(@Nullable String text, @Nullable ItemStack defaultItemStack) {
        ItemStack returnValue;
        if (text == null || text.isBlank()) {
            return defaultItemStack;
        }
        try {
            returnValue = Bukkit.getItemFactory().createItemStack(text);
        }
        catch (IllegalArgumentException exception) {
            returnValue = ItemParser.parseOld(text, defaultItemStack);
        }
        return returnValue;
    }

    private static @Nullable ItemStack parseOld(@Nullable String text, @Nullable ItemStack defaultItemStack) {
        if (text == null || text.isBlank()) {
            return defaultItemStack;
        }
        ItemStack returnValue = defaultItemStack;
        String[] part = text.split(":");
        try {
            Optional<String> first = Arrays.stream(part).filter(field -> field.matches("(CMD-\\d*)")).findFirst();
            Integer customModelData = null;
            if (first.isPresent()) {
                String[] copyParts = new String[part.length - 1];
                int j = 0;
                for (String field2 : part) {
                    if (field2.matches("(CMD-\\d*)")) continue;
                    copyParts[j++] = field2;
                }
                part = copyParts;
                customModelData = Integer.valueOf(first.get().replaceFirst("CMD-", ""));
            }
            if (part.length == 1) {
                returnValue = new ItemStack(Material.valueOf((String)part[0].toUpperCase()));
            } else if (part[0].contains("POTION") || part[0].equalsIgnoreCase("TIPPED_ARROW")) {
                returnValue = ItemParser.parsePotion(part);
            } else if (part[0].contains("BANNER")) {
                returnValue = ItemParser.parseBanner(part);
            } else if (part[0].equalsIgnoreCase("PLAYER_HEAD")) {
                returnValue = ItemParser.parsePlayerHead(part);
            } else if (part.length == 2) {
                returnValue = ItemParser.parseItemQuantity(part);
            } else if (part.length == 3) {
                returnValue = ItemParser.parseItemDurabilityAndQuantity(part);
            }
            if (returnValue != null && customModelData != null) {
                ItemParser.setCustomModelData(returnValue, customModelData);
            }
        }
        catch (Exception exception) {
            BentoBox.getInstance().logError("Could not parse item " + text + " " + exception.getLocalizedMessage());
            returnValue = defaultItemStack;
        }
        return returnValue;
    }

    private static void setCustomModelData(ItemStack returnValue, Integer customModelData) {
        ItemMeta itemMeta = returnValue.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setCustomModelData(customModelData);
            returnValue.setItemMeta(itemMeta);
        }
    }

    private static ItemStack parseItemQuantity(String[] part) {
        int reqAmount = Integer.parseInt(part[1]);
        Material reqItem = Material.getMaterial((String)part[0].toUpperCase(Locale.ENGLISH));
        if (reqItem == null) {
            throw new IllegalArgumentException(part[0] + " is not a valid Material.");
        }
        return new ItemStack(reqItem, reqAmount);
    }

    private static ItemStack parseItemDurabilityAndQuantity(String[] part) {
        String[] parsable = new String[]{part[0], part[2]};
        ItemStack durability = ItemParser.parseItemQuantity(parsable);
        ItemMeta meta = durability.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(Integer.parseInt(part[1]));
            durability.setItemMeta(meta);
        }
        return durability;
    }

    @Deprecated
    private static ItemStack parsePotionOld(String[] part) {
        if (part.length != 6) {
            throw new MissingFormatArgumentException("Potion parsing requires 6 parts.");
        }
        ItemStack result = new ItemStack(Material.POTION);
        if (part[4].equalsIgnoreCase("SPLASH")) {
            result = new ItemStack(Material.SPLASH_POTION);
        } else if (part[4].equalsIgnoreCase("LINGER")) {
            result = new ItemStack(Material.LINGERING_POTION);
        }
        if (part[0].equalsIgnoreCase("TIPPED_ARROW")) {
            result = new ItemStack(Material.TIPPED_ARROW);
        }
        PotionMeta potionMeta = (PotionMeta)result.getItemMeta();
        PotionType type = PotionType.valueOf((String)part[1].toUpperCase(Locale.ENGLISH));
        boolean isUpgraded = !part[2].isEmpty() && !part[2].equalsIgnoreCase("1");
        boolean isExtended = part[3].equalsIgnoreCase("EXTENDED");
        PotionData data = new PotionData(type, isExtended, isUpgraded);
        potionMeta.setBasePotionType(type);
        result.setItemMeta((ItemMeta)potionMeta);
        result.setAmount(Integer.parseInt(part[5]));
        return result;
    }

    private static ItemStack parsePotion(String[] part) {
        ItemStack result;
        ItemMeta itemMeta;
        if (part.length == 6) {
            BentoBox.getInstance().logWarning("The old potion parsing detected for " + part[0] + ". Please update your configs, as SPIGOT changed potion types.");
            return ItemParser.parsePotionOld(part);
        }
        if (part.length != 3) {
            throw new MissingFormatArgumentException("Potion parsing requires 3 parts.");
        }
        Material material = Material.matchMaterial((String)part[0]);
        if (material == null) {
            BentoBox.getInstance().logWarning("Could not parse potion item " + part[0] + " so using a regular potion.");
            material = Material.POTION;
        }
        if ((itemMeta = (result = new ItemStack(material, Integer.parseInt(part[2]))).getItemMeta()) instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)itemMeta;
            PotionType potionType = (PotionType)Enums.getIfPresent(PotionType.class, (String)part[1].toUpperCase(Locale.ENGLISH)).or((Object)PotionType.WATER);
            meta.setBasePotionType(potionType);
            result.setItemMeta((ItemMeta)meta);
        }
        return result;
    }

    static ItemStack parseBanner(String[] part) {
        if (part.length >= 2) {
            ItemStack result;
            BannerMeta meta;
            Material bannerMat = Material.getMaterial((String)part[0]);
            if (bannerMat == null) {
                BentoBox.getInstance().logError("Could not parse banner item " + part[0] + " so using a white banner.");
                bannerMat = Material.WHITE_BANNER;
            }
            if ((meta = (BannerMeta)(result = new ItemStack(bannerMat, Integer.parseInt(part[1]))).getItemMeta()) != null) {
                for (int i = 2; i < part.length; i += 2) {
                    PatternType pt = PatternType.valueOf((String)part[i]);
                    DyeColor dc = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)part[i + 1]).orNull();
                    if (dc == null) continue;
                    meta.addPattern(new Pattern(dc, pt));
                }
                result.setItemMeta((ItemMeta)meta);
            }
            return result;
        }
        throw new MissingFormatArgumentException("Banner parsing requires at least 2 parts.");
    }

    private static ItemStack parsePlayerHead(String[] part) {
        ItemStack playerHead;
        if (part.length == 3) {
            String[] parsable = new String[]{part[0], part[2]};
            playerHead = ItemParser.parseItemQuantity(parsable);
        } else {
            if (ItemParser.isNumeric(part[1])) {
                return ItemParser.parseItemQuantity(part);
            }
            playerHead = new ItemStack(Material.PLAYER_HEAD);
        }
        try {
            ItemMeta itemMeta = playerHead.getItemMeta();
            if (itemMeta instanceof SkullMeta) {
                PlayerProfile profile;
                SkullMeta meta = (SkullMeta)itemMeta;
                if (part[1].length() < 17) {
                    profile = Bukkit.createPlayerProfile((String)part[1]);
                } else if (part[1].length() == 32) {
                    profile = Bukkit.createPlayerProfile((UUID)UUID.fromString(part[1].replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")));
                } else if (part[1].length() == 36) {
                    profile = Bukkit.createPlayerProfile((UUID)UUID.fromString(part[1]));
                } else {
                    profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)"");
                    profile.getTextures().setSkin(ItemParser.getSkinURLFromBase64(part[1]));
                }
                meta.setOwnerProfile(profile);
                playerHead.setItemMeta((ItemMeta)meta);
            }
        }
        catch (Exception ignored) {
            BentoBox.getInstance().logError("Could not parse player head item " + part[1] + " so using a Steve head.");
        }
        return playerHead;
    }

    private static URL getSkinURLFromBase64(String base64) {
        try {
            String decoded = new String(Base64.getDecoder().decode(base64));
            JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
            String url = json.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            return new URI(url).toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isNumeric(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

